/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.cursors;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.DurableTopicSubscription;
import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.Topic;
import com.bes.mq.broker.region.cursors.AbstractPendingMessageCursor;
import com.bes.mq.broker.region.cursors.AbstractStoreCursor;
import com.bes.mq.broker.region.cursors.FilePendingMessageCursor;
import com.bes.mq.broker.region.cursors.PendingMessageCursor;
import com.bes.mq.broker.region.cursors.TopicStorePrefetch;
import com.bes.mq.broker.region.cursors.VMPendingMessageCursor;
import com.bes.mq.command.Message;
import com.bes.mq.notification.NotificationSupport;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.usage.SystemUsage;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreDurableSubscriberCursor
extends AbstractPendingMessageCursor {
    private static final Logger LOG = LoggerFactory.getLogger(StoreDurableSubscriberCursor.class);
    private final String clientId;
    private final String subscriberName;
    private final Map<Destination, TopicStorePrefetch> topics = new HashMap<Destination, TopicStorePrefetch>();
    private final List<PendingMessageCursor> storePrefetches = new CopyOnWriteArrayList<PendingMessageCursor>();
    private final PendingMessageCursor nonPersistent;
    private PendingMessageCursor currentCursor;
    private final DurableTopicSubscription subscription;
    private boolean immediatePriorityDispatch = true;

    public StoreDurableSubscriberCursor(Broker broker, String clientId, String subscriberName, int maxBatchSize, DurableTopicSubscription subscription) {
        super(AbstractPendingMessageCursor.isPrioritizedMessageSubscriber(broker, subscription));
        this.subscription = subscription;
        this.clientId = clientId;
        this.subscriberName = subscriberName;
        this.nonPersistent = broker.getBrokerService().isPersistent() ? new FilePendingMessageCursor(broker, clientId + subscriberName, this.prioritizedMessages) : new VMPendingMessageCursor(this.prioritizedMessages);
        this.nonPersistent.setMaxBatchSize(maxBatchSize);
        this.nonPersistent.setSystemUsage(this.systemUsage);
        this.storePrefetches.add(this.nonPersistent);
        if (this.prioritizedMessages) {
            this.setMaxAuditDepth(10 * this.getMaxAuditDepth());
        }
    }

    @Override
    public synchronized void start() throws Exception {
        if (!this.isStarted()) {
            super.start();
            for (PendingMessageCursor tsp : this.storePrefetches) {
                tsp.setMessageAudit(this.getMessageAudit());
                tsp.start();
            }
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.isStarted()) {
            if (this.subscription.isKeepDurableSubsActive()) {
                super.gc();
                for (PendingMessageCursor tsp : this.storePrefetches) {
                    tsp.gc();
                }
            } else {
                super.stop();
                for (PendingMessageCursor tsp : this.storePrefetches) {
                    tsp.destroy();
                }
                this.getMessageAudit().clear();
            }
        }
    }

    @Override
    public synchronized void add(ConnectionContext context, Destination destination) throws Exception {
        if (destination != null && !NotificationSupport.isNotificationTopic(destination.getBESMQDestination())) {
            TopicStorePrefetch tsp = new TopicStorePrefetch(this.subscription, (Topic)destination, this.clientId, this.subscriberName);
            tsp.setMaxBatchSize(destination.getMaxPageSize());
            tsp.setSystemUsage(this.systemUsage);
            tsp.setMessageAudit(this.getMessageAudit());
            tsp.setEnableAudit(this.isEnableAudit());
            tsp.setMemoryUsageHighWaterMark(this.getMemoryUsageHighWaterMark());
            tsp.setUseCache(this.isUseCache());
            tsp.setCacheEnabled(this.isUseCache() && tsp.isEmpty());
            this.topics.put(destination, tsp);
            this.storePrefetches.add(tsp);
            if (this.isStarted()) {
                tsp.start();
            }
        }
    }

    @Override
    public synchronized List<MessageReference> remove(ConnectionContext context, Destination destination) throws Exception {
        PendingMessageCursor tsp = this.topics.remove(destination);
        if (tsp != null) {
            this.storePrefetches.remove(tsp);
            tsp.stop();
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public synchronized boolean isEmpty() {
        for (PendingMessageCursor tsp : this.storePrefetches) {
            if (tsp.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean isEmpty(Destination destination) {
        boolean result = true;
        TopicStorePrefetch tsp = this.topics.get(destination);
        if (tsp != null) {
            result = tsp.isEmpty();
        }
        return result;
    }

    @Override
    public boolean isRecoveryRequired() {
        return false;
    }

    @Override
    public synchronized void addMessageLast(MessageReference node) throws Exception {
        this.internalAddMessageLast(node, false, Long.MAX_VALUE);
    }

    @Override
    public synchronized boolean tryAddMessageLast(MessageReference node, long maxWaitTime) throws Exception {
        return this.internalAddMessageLast(node, true, maxWaitTime);
    }

    protected boolean internalAddMessageLast(MessageReference node, boolean useTry, long maxWaitTime) throws Exception {
        if (node != null) {
            Destination dest;
            TopicStorePrefetch tsp;
            Message msg = node.getMessage();
            if (this.isStarted() && !msg.isPersistent()) {
                if (useTry) {
                    return this.nonPersistent.tryAddMessageLast(node, maxWaitTime);
                }
                this.nonPersistent.addMessageLast(node);
            }
            if (msg.isPersistent() && (tsp = this.topics.get(dest = msg.getRegionDestination())) != null) {
                tsp.addMessageLast(node);
                if (this.prioritizedMessages && this.immediatePriorityDispatch && tsp.isPaging() && msg.getPriority() > tsp.getLastRecoveredPriority()) {
                    tsp.recoverMessage(node.getMessage(), true);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Cached high priority (" + msg.getPriority() + ") message:" + msg.getMessageId() + ", current paged batch priority: " + tsp.getLastRecoveredPriority() + ", cache size:" + tsp.batchList.size());
                    }
                }
            }
        }
        return true;
    }

    @Override
    public boolean isTransient() {
        return this.subscription.isKeepDurableSubsActive();
    }

    @Override
    public void addMessageFirst(MessageReference node) throws Exception {
        if (node != null) {
            Message msg = node.getMessage();
            if (!msg.isPersistent()) {
                this.nonPersistent.addMessageFirst(node);
            } else {
                Destination dest = msg.getRegionDestination();
                TopicStorePrefetch tsp = this.topics.get(dest);
                if (tsp != null) {
                    tsp.addMessageFirst(node);
                }
            }
        }
    }

    @Override
    public synchronized void addRecoveredMessage(MessageReference node) throws Exception {
        this.nonPersistent.addMessageLast(node);
    }

    @Override
    public synchronized void clear() {
        for (PendingMessageCursor tsp : this.storePrefetches) {
            tsp.clear();
        }
    }

    @Override
    public synchronized boolean hasNext() {
        boolean result = true;
        if (result) {
            try {
                this.currentCursor = this.getNextCursor();
            }
            catch (Exception e) {
                LOG.error("Failed to get current cursor ", e);
                throw new RuntimeException(e);
            }
            result = this.currentCursor != null ? this.currentCursor.hasNext() : false;
        }
        return result;
    }

    @Override
    public synchronized MessageReference next() {
        MessageReference result = this.currentCursor != null ? this.currentCursor.next() : null;
        return result;
    }

    @Override
    public synchronized void remove() {
        if (this.currentCursor != null) {
            this.currentCursor.remove();
        }
    }

    @Override
    public synchronized void remove(MessageReference node) {
        for (PendingMessageCursor tsp : this.storePrefetches) {
            tsp.remove(node);
        }
    }

    @Override
    public synchronized void reset() {
        for (PendingMessageCursor storePrefetch : this.storePrefetches) {
            storePrefetch.reset();
        }
    }

    @Override
    public synchronized void release() {
        this.currentCursor = null;
        for (PendingMessageCursor storePrefetch : this.storePrefetches) {
            storePrefetch.release();
        }
    }

    @Override
    public synchronized int size() {
        int pendingCount = 0;
        for (PendingMessageCursor tsp : this.storePrefetches) {
            pendingCount += tsp.size();
        }
        return pendingCount;
    }

    @Override
    public void setMaxBatchSize(int newMaxBatchSize) {
        for (PendingMessageCursor storePrefetch : this.storePrefetches) {
            storePrefetch.setMaxBatchSize(newMaxBatchSize);
        }
        super.setMaxBatchSize(newMaxBatchSize);
    }

    @Override
    public synchronized void gc() {
        for (PendingMessageCursor tsp : this.storePrefetches) {
            tsp.gc();
        }
    }

    @Override
    public void setSystemUsage(SystemUsage usageManager) {
        super.setSystemUsage(usageManager);
        for (PendingMessageCursor tsp : this.storePrefetches) {
            tsp.setSystemUsage(usageManager);
        }
    }

    @Override
    public void setMemoryUsageHighWaterMark(int memoryUsageHighWaterMark) {
        super.setMemoryUsageHighWaterMark(memoryUsageHighWaterMark);
        for (PendingMessageCursor cursor : this.storePrefetches) {
            cursor.setMemoryUsageHighWaterMark(memoryUsageHighWaterMark);
        }
    }

    @Override
    public void setMaxProducersToAudit(int maxProducersToAudit) {
        super.setMaxProducersToAudit(maxProducersToAudit);
        for (PendingMessageCursor cursor : this.storePrefetches) {
            cursor.setMaxProducersToAudit(maxProducersToAudit);
        }
    }

    @Override
    public void setMaxAuditDepth(int maxAuditDepth) {
        super.setMaxAuditDepth(maxAuditDepth);
        for (PendingMessageCursor cursor : this.storePrefetches) {
            cursor.setMaxAuditDepth(maxAuditDepth);
        }
    }

    @Override
    public void setEnableAudit(boolean enableAudit) {
        super.setEnableAudit(enableAudit);
        for (PendingMessageCursor cursor : this.storePrefetches) {
            cursor.setEnableAudit(enableAudit);
        }
    }

    @Override
    public void setUseCache(boolean useCache) {
        super.setUseCache(useCache);
        for (PendingMessageCursor cursor : this.storePrefetches) {
            cursor.setUseCache(useCache);
        }
    }

    protected synchronized PendingMessageCursor getNextCursor() throws Exception {
        if (this.currentCursor == null || this.currentCursor.isEmpty() || !this.currentCursor.hasNext()) {
            this.currentCursor = null;
            for (PendingMessageCursor tsp : this.storePrefetches) {
                if (!tsp.hasNext()) continue;
                this.currentCursor = tsp;
                break;
            }
            if (this.storePrefetches.size() > 1) {
                PendingMessageCursor first = this.storePrefetches.remove(0);
                this.storePrefetches.add(first);
            }
        }
        return this.currentCursor;
    }

    @Override
    public synchronized boolean isInMemory(MessageReference node) {
        for (PendingMessageCursor tsp : this.storePrefetches) {
            if (!tsp.isInMemory(node)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "StoreDurableSubscriber(" + this.clientId + ":" + this.subscriberName + ")";
    }

    public boolean isImmediatePriorityDispatch() {
        return this.immediatePriorityDispatch;
    }

    public void setImmediatePriorityDispatch(boolean immediatePriorityDispatch) {
        this.immediatePriorityDispatch = immediatePriorityDispatch;
    }

    public long getDuplicateMessagesFromProducer() {
        long count = 0L;
        for (PendingMessageCursor tsp : this.storePrefetches) {
            if (!(tsp instanceof AbstractStoreCursor)) continue;
            count += ((AbstractStoreCursor)tsp).getDuplicateMessagesFromProducer();
        }
        return count;
    }

    public long getDuplicateMessagesFromStore() {
        long count = 0L;
        for (PendingMessageCursor tsp : this.storePrefetches) {
            if (!(tsp instanceof AbstractStoreCursor)) continue;
            count += ((AbstractStoreCursor)tsp).getDuplicateMessagesFromStore();
        }
        return count;
    }
}

