/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.cursors;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.Queue;
import com.bes.mq.broker.region.cursors.AbstractPendingMessageCursor;
import com.bes.mq.broker.region.cursors.FilePendingMessageCursor;
import com.bes.mq.broker.region.cursors.PendingMessageCursor;
import com.bes.mq.broker.region.cursors.QueueStorePrefetch;
import com.bes.mq.broker.region.cursors.VMPendingMessageCursor;
import com.bes.mq.command.Message;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.usage.SystemUsage;

public class StoreQueueCursor
extends AbstractPendingMessageCursor {
    private static final Logger LOG = LoggerFactory.getLogger(StoreQueueCursor.class);
    private final Broker broker;
    private int pendingCount;
    private final Queue queue;
    private PendingMessageCursor nonPersistent;
    private final QueueStorePrefetch persistent;
    private boolean started;
    private PendingMessageCursor currentCursor;

    public StoreQueueCursor(Broker broker, Queue queue) {
        super(queue != null ? queue.isPrioritizedMessages() : false);
        this.broker = broker;
        this.queue = queue;
        this.persistent = new QueueStorePrefetch(queue);
        this.nonPersistent = broker.getBrokerService().isPersistent() ? new FilePendingMessageCursor(broker, queue.getName(), this.prioritizedMessages) : new VMPendingMessageCursor(this.prioritizedMessages);
        this.currentCursor = this.persistent;
    }

    public synchronized void start() throws Exception {
        this.started = true;
        super.start();
        this.nonPersistent.setMaxBatchSize(this.getMaxBatchSize());
        this.nonPersistent.setSystemUsage(this.systemUsage);
        this.nonPersistent.setEnableAudit(this.isEnableAudit());
        this.nonPersistent.setMaxAuditDepth(this.getMaxAuditDepth());
        this.nonPersistent.setMaxProducersToAudit(this.getMaxProducersToAudit());
        this.nonPersistent.setMessageAudit(this.getMessageAudit());
        this.nonPersistent.start();
        this.persistent.setMessageAudit(this.getMessageAudit());
        this.persistent.start();
        this.pendingCount = this.persistent.size() + this.nonPersistent.size();
    }

    public synchronized void stop() throws Exception {
        this.started = false;
        if (this.nonPersistent != null) {
            this.nonPersistent.destroy();
        }
        this.persistent.stop();
        super.stop();
        this.pendingCount = 0;
    }

    public synchronized void addMessageLast(MessageReference node) throws Exception {
        this.internalAddMessageLast(node, false, Long.MAX_VALUE);
    }

    public synchronized boolean tryAddMessageLast(MessageReference node, long maxWaitTime) throws Exception {
        return this.internalAddMessageLast(node, true, maxWaitTime);
    }

    protected boolean internalAddMessageLast(MessageReference node, boolean useTry, long maxWaitTime) throws Exception {
        if (node != null) {
            Message msg = node.getMessage();
            if (this.started) {
                ++this.pendingCount;
                if (!msg.isPersistent()) {
                    if (useTry) {
                        return this.nonPersistent.tryAddMessageLast(node, maxWaitTime);
                    }
                    this.nonPersistent.addMessageLast(node);
                }
            }
            if (msg.isPersistent()) {
                this.persistent.addMessageLast(node);
            }
        }
        return true;
    }

    public synchronized void addMessageFirst(MessageReference node) throws Exception {
        if (node != null) {
            Message msg = node.getMessage();
            if (this.started) {
                ++this.pendingCount;
                if (!msg.isPersistent()) {
                    this.nonPersistent.addMessageFirst(node);
                }
            }
            if (msg.isPersistent()) {
                this.persistent.addMessageFirst(node);
            }
        }
    }

    public synchronized void clear() {
        if (this.nonPersistent != null) {
            this.nonPersistent.clear();
        }
        this.persistent.clear();
        this.pendingCount = 0;
    }

    public synchronized boolean hasNext() {
        try {
            this.getNextCursor();
        }
        catch (Exception e) {
            LOG.error("Failed to get current cursor ", e);
            throw new RuntimeException(e);
        }
        return this.currentCursor != null ? this.currentCursor.hasNext() : false;
    }

    public synchronized MessageReference next() {
        MessageReference result = this.currentCursor != null ? this.currentCursor.next() : null;
        return result;
    }

    public synchronized void remove() {
        if (this.currentCursor != null) {
            this.currentCursor.remove();
        }
        --this.pendingCount;
    }

    public synchronized void remove(MessageReference node) {
        if (!node.isPersistent()) {
            this.nonPersistent.remove(node);
        } else {
            this.persistent.remove(node);
        }
        --this.pendingCount;
    }

    public synchronized void reset() {
        this.nonPersistent.reset();
        this.persistent.reset();
        this.pendingCount = this.persistent.size() + this.nonPersistent.size();
    }

    public void release() {
        this.nonPersistent.release();
        this.persistent.release();
    }

    public synchronized int size() {
        if (this.pendingCount < 0) {
            this.pendingCount = this.persistent.size() + this.nonPersistent.size();
        }
        return this.pendingCount;
    }

    public synchronized boolean isEmpty() {
        return this.pendingCount == 0;
    }

    public boolean isRecoveryRequired() {
        return false;
    }

    public PendingMessageCursor getNonPersistent() {
        return this.nonPersistent;
    }

    public void setNonPersistent(PendingMessageCursor nonPersistent) {
        this.nonPersistent = nonPersistent;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.persistent.setMaxBatchSize(maxBatchSize);
        if (this.nonPersistent != null) {
            this.nonPersistent.setMaxBatchSize(maxBatchSize);
        }
        super.setMaxBatchSize(maxBatchSize);
    }

    public void setMaxProducersToAudit(int maxProducersToAudit) {
        super.setMaxProducersToAudit(maxProducersToAudit);
        if (this.persistent != null) {
            this.persistent.setMaxProducersToAudit(maxProducersToAudit);
        }
        if (this.nonPersistent != null) {
            this.nonPersistent.setMaxProducersToAudit(maxProducersToAudit);
        }
    }

    public void setMaxAuditDepth(int maxAuditDepth) {
        super.setMaxAuditDepth(maxAuditDepth);
        if (this.persistent != null) {
            this.persistent.setMaxAuditDepth(maxAuditDepth);
        }
        if (this.nonPersistent != null) {
            this.nonPersistent.setMaxAuditDepth(maxAuditDepth);
        }
    }

    public void setEnableAudit(boolean enableAudit) {
        super.setEnableAudit(enableAudit);
        if (this.persistent != null) {
            this.persistent.setEnableAudit(enableAudit);
        }
        if (this.nonPersistent != null) {
            this.nonPersistent.setEnableAudit(enableAudit);
        }
    }

    public void setUseCache(boolean useCache) {
        super.setUseCache(useCache);
        if (this.persistent != null) {
            this.persistent.setUseCache(useCache);
        }
        if (this.nonPersistent != null) {
            this.nonPersistent.setUseCache(useCache);
        }
    }

    public void setMemoryUsageHighWaterMark(int memoryUsageHighWaterMark) {
        super.setMemoryUsageHighWaterMark(memoryUsageHighWaterMark);
        if (this.persistent != null) {
            this.persistent.setMemoryUsageHighWaterMark(memoryUsageHighWaterMark);
        }
        if (this.nonPersistent != null) {
            this.nonPersistent.setMemoryUsageHighWaterMark(memoryUsageHighWaterMark);
        }
    }

    public synchronized void gc() {
        if (this.persistent != null) {
            this.persistent.gc();
        }
        if (this.nonPersistent != null) {
            this.nonPersistent.gc();
        }
        this.pendingCount = this.persistent.size() + this.nonPersistent.size();
    }

    public void setSystemUsage(SystemUsage usageManager) {
        super.setSystemUsage(usageManager);
        if (this.persistent != null) {
            this.persistent.setSystemUsage(usageManager);
        }
        if (this.nonPersistent != null) {
            this.nonPersistent.setSystemUsage(usageManager);
        }
    }

    protected synchronized PendingMessageCursor getNextCursor() throws Exception {
        if (this.currentCursor == null || !this.currentCursor.hasMessagesBufferedToDeliver()) {
            this.switchCursor();
            if (this.currentCursor.isEmpty()) {
                this.currentCursor = this.currentCursor == this.persistent ? this.nonPersistent : this.persistent;
            }
        }
        return this.currentCursor;
    }

    public void switchCursor() {
        this.currentCursor = this.currentCursor == this.persistent ? this.nonPersistent : this.persistent;
    }

    public boolean isInMemory(MessageReference node) {
        return this.nonPersistent.isInMemory(node) || this.persistent.isInMemory(node);
    }

    public boolean isCacheEnabled() {
        boolean cacheEnabled = this.isUseCache();
        return cacheEnabled;
    }

    public long getDuplicateMessagesFromProducer() {
        return this.persistent.getDuplicateMessagesFromProducer();
    }

    public long getDuplicateMessagesFromStore() {
        return this.persistent.getDuplicateMessagesFromStore();
    }
}

