/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.cursors;

import com.bes.mq.broker.region.Subscription;
import com.bes.mq.broker.region.Topic;
import com.bes.mq.broker.region.cursors.AbstractStoreCursor;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageId;
import com.bes.mq.filter.MessageEvaluationContext;
import com.bes.mq.filter.NonCachedMessageEvaluationContext;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.store.TopicMessageStore;
import com.bes.mq.store.hsdb.TopicMessageStoreExt;

class TopicStorePrefetch
extends AbstractStoreCursor {
    private static final Logger LOG = LoggerFactory.getLogger(TopicStorePrefetch.class);
    private final TopicMessageStore store;
    private final String clientId;
    private final String subscriberName;
    private final Subscription subscription;
    private byte lastRecoveredPriority = (byte)9;

    public TopicStorePrefetch(Subscription subscription, Topic topic, String clientId, String subscriberName) {
        super(topic);
        this.subscription = subscription;
        this.store = (TopicMessageStore)topic.getMessageStore();
        this.clientId = clientId;
        this.subscriberName = subscriberName;
        this.maxProducersToAudit = 32;
        this.maxAuditDepth = 10000;
        this.resetSize();
    }

    public boolean recoverMessageReference(MessageId messageReference) throws Exception {
        throw new RuntimeException("Not supported");
    }

    public synchronized boolean recoverMessage(Message message, boolean cached) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Recover: " + message.getMessageId() + ", priority: " + message.getPriority());
        }
        boolean recovered = false;
        NonCachedMessageEvaluationContext messageEvaluationContext = new NonCachedMessageEvaluationContext();
        ((MessageEvaluationContext)messageEvaluationContext).setMessageReference(message);
        if (this.subscription.matches(message, messageEvaluationContext) && (recovered = super.recoverMessage(message, cached)) && !cached) {
            this.lastRecoveredPriority = message.getPriority();
        }
        return recovered;
    }

    protected synchronized int getStoreSize() {
        try {
            return this.store.getMessageCount(this.clientId, this.subscriberName);
        }
        catch (Exception e) {
            LOG.error(this + " Failed to get the outstanding message count from the store", e);
            throw new RuntimeException(e);
        }
    }

    protected synchronized boolean isStoreEmpty() {
        try {
            return this.store.isEmpty();
        }
        catch (Exception e) {
            LOG.error("Failed to determine if store is empty", e);
            throw new RuntimeException(e);
        }
    }

    protected void setBatch(MessageId messageId, Integer priority) throws Exception {
        if (this.store instanceof TopicMessageStoreExt) {
            ((TopicMessageStoreExt)((Object)this.store)).setBatch(this.clientId, this.subscriberName, messageId, priority);
        }
    }

    protected void resetBatch() {
        this.store.resetBatching(this.clientId, this.subscriberName);
    }

    protected void doFillBatch() throws Exception {
        this.store.recoverNextMessages(this.clientId, this.subscriberName, this.maxBatchSize, this);
    }

    public byte getLastRecoveredPriority() {
        return this.lastRecoveredPriority;
    }

    public final boolean isPaging() {
        return !this.isCacheEnabled() && !this.batchList.isEmpty();
    }

    public String toString() {
        return "TopicStorePrefetch(" + this.clientId + "," + this.subscriberName + ") " + this.subscription.getConsumerInfo().getConsumerId() + " - " + super.toString();
    }
}

