/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.cursors;

import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.QueueMessageReference;
import com.bes.mq.broker.region.cursors.AbstractPendingMessageCursor;
import com.bes.mq.broker.region.cursors.OrderedPendingList;
import com.bes.mq.broker.region.cursors.PendingList;
import com.bes.mq.broker.region.cursors.PrioritizedPendingList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMPendingMessageCursor
extends AbstractPendingMessageCursor {
    private final PendingList list;
    private Iterator<MessageReference> iter;

    public VMPendingMessageCursor(boolean prioritizedMessages) {
        super(prioritizedMessages);
        this.list = this.prioritizedMessages ? new PrioritizedPendingList() : new OrderedPendingList();
    }

    @Override
    public synchronized List<MessageReference> remove(ConnectionContext context, Destination destination) throws Exception {
        ArrayList<MessageReference> rc = new ArrayList<MessageReference>();
        Iterator<MessageReference> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            MessageReference r = iterator.next();
            if (r.getRegionDestination() != destination) continue;
            rc.add(r);
            iterator.remove();
        }
        return rc;
    }

    @Override
    public synchronized boolean isEmpty() {
        if (this.list.isEmpty()) {
            return true;
        }
        Iterator<MessageReference> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            MessageReference node = iterator.next();
            if (node == QueueMessageReference.NULL_MESSAGE) continue;
            if (!node.isDropped()) {
                return false;
            }
            iterator.remove();
        }
        return true;
    }

    @Override
    public synchronized void reset() {
        this.iter = this.list.iterator();
        this.last = null;
    }

    @Override
    public synchronized void addMessageLast(MessageReference node) {
        this.list.addMessageLast(node);
    }

    @Override
    public synchronized void addMessageFirst(MessageReference node) {
        this.list.addMessageFirst(node);
    }

    @Override
    public synchronized boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public synchronized MessageReference next() {
        this.last = this.iter.next();
        return this.last;
    }

    @Override
    public synchronized void remove() {
        this.iter.remove();
    }

    @Override
    public synchronized int size() {
        return this.list.size();
    }

    @Override
    public synchronized void clear() {
        for (MessageReference ref : this.list) {
            ref.decrementReferenceCount();
        }
        this.list.clear();
    }

    @Override
    public synchronized void remove(MessageReference node) {
        this.list.remove(node);
    }

    @Override
    public LinkedList<MessageReference> pageInList(int maxItems) {
        LinkedList<MessageReference> result = new LinkedList<MessageReference>();
        for (MessageReference ref : this.list) {
            result.add(ref);
            if (result.size() < maxItems) continue;
            break;
        }
        return result;
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    @Override
    public void destroy() throws Exception {
        super.destroy();
        this.clear();
    }

    @Override
    public synchronized boolean isInMemory(MessageReference node) {
        return this.list.contains(node);
    }
}

