/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.group;

import com.bes.mq.broker.region.group.EmptyMessageGroupSet;
import com.bes.mq.broker.region.group.MessageGroupMap;
import com.bes.mq.broker.region.group.MessageGroupSet;
import com.bes.mq.command.ConsumerId;

public class MessageGroupHashBucket
implements MessageGroupMap {
    private final int bucketCount;
    private final ConsumerId[] consumers;

    public MessageGroupHashBucket(int bucketCount) {
        this.bucketCount = bucketCount;
        this.consumers = new ConsumerId[bucketCount];
    }

    public void put(String groupId, ConsumerId consumerId) {
        int bucket = this.getBucketNumber(groupId);
        this.consumers[bucket] = consumerId;
    }

    public ConsumerId get(String groupId) {
        int bucket = this.getBucketNumber(groupId);
        return this.consumers[bucket];
    }

    public ConsumerId removeGroup(String groupId) {
        int bucket = this.getBucketNumber(groupId);
        ConsumerId answer = this.consumers[bucket];
        this.consumers[bucket] = null;
        return answer;
    }

    public MessageGroupSet removeConsumer(ConsumerId consumerId) {
        MessageGroupSet answer = null;
        for (int i = 0; i < this.consumers.length; ++i) {
            ConsumerId owner = this.consumers[i];
            if (owner == null || !owner.equals(consumerId)) continue;
            answer = this.createMessageGroupSet(i, answer);
            this.consumers[i] = null;
        }
        if (answer == null) {
            answer = EmptyMessageGroupSet.INSTANCE;
        }
        return answer;
    }

    public String toString() {
        int count = 0;
        for (int i = 0; i < this.consumers.length; ++i) {
            if (this.consumers[i] == null) continue;
            ++count;
        }
        return "active message group buckets: " + count;
    }

    protected MessageGroupSet createMessageGroupSet(int bucketNumber, final MessageGroupSet parent) {
        final MessageGroupSet answer = this.createMessageGroupSet(bucketNumber);
        if (parent == null) {
            return answer;
        }
        return new MessageGroupSet(){

            public boolean contains(String groupID) {
                return parent.contains(groupID) || answer.contains(groupID);
            }
        };
    }

    protected MessageGroupSet createMessageGroupSet(final int bucketNumber) {
        return new MessageGroupSet(){

            public boolean contains(String groupID) {
                int bucket = MessageGroupHashBucket.this.getBucketNumber(groupID);
                return bucket == bucketNumber;
            }
        };
    }

    protected int getBucketNumber(String groupId) {
        int bucket = groupId.hashCode() % this.bucketCount;
        if (bucket < 0) {
            bucket *= -1;
        }
        return bucket;
    }
}

