/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.policy;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.Connection;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.broker.region.policy.SlowConsumerEntry;
import com.bes.mq.broker.region.policy.SlowConsumerStrategy;
import com.bes.mq.command.ConsumerControl;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.thread.Scheduler;
import com.bes.mq.transport.InactivityIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbortSlowConsumerStrategy
implements SlowConsumerStrategy,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AbortSlowConsumerStrategy.class);
    private String name = "AbortSlowConsumerStrategy@" + this.hashCode();
    private Scheduler scheduler;
    private Broker broker;
    private final AtomicBoolean taskStarted = new AtomicBoolean(false);
    private final Map<Subscription, SlowConsumerEntry> slowConsumers = new ConcurrentHashMap<Subscription, SlowConsumerEntry>();
    private long maxSlowCount = -1L;
    private long maxSlowDuration = 30000L;
    private long checkPeriod = 30000L;
    private boolean abortConnection = false;

    @Override
    public void setBrokerService(Broker broker) {
        this.scheduler = broker.getScheduler();
        this.broker = broker;
    }

    @Override
    public void slowConsumer(ConnectionContext context, Subscription subs) {
        if (this.maxSlowCount < 0L && this.maxSlowDuration < 0L) {
            LOG.info("No limits set, slowConsumer strategy has nothing to do");
            return;
        }
        if (this.taskStarted.compareAndSet(false, true)) {
            this.scheduler.executePeriodically(this, this.checkPeriod);
        }
        if (!this.slowConsumers.containsKey(subs)) {
            this.slowConsumers.put(subs, new SlowConsumerEntry(context));
        } else if (this.maxSlowCount > 0L) {
            SlowConsumerEntry entry = this.slowConsumers.get(subs);
            entry.slow();
            LOG.debug("Slow consumer:" + subs.getConsumerInfo().getConsumerId() + ",consumer slowCount:" + entry.slowCount + ",consumer maxSlowCount:" + this.maxSlowCount);
        }
    }

    @Override
    public void run() {
        if (this.maxSlowDuration > 0L) {
            for (Map.Entry<Subscription, SlowConsumerEntry> entry : this.slowConsumers.entrySet()) {
                entry.getValue().mark();
                LOG.debug("Slow consumer:" + entry.getKey().getConsumerInfo().getConsumerId() + ",consumer duration:" + (long)entry.getValue().markCount * this.checkPeriod + ",consumer maxSlowDuration:" + this.maxSlowDuration);
            }
        }
        HashMap<Subscription, SlowConsumerEntry> toAbort = new HashMap<Subscription, SlowConsumerEntry>();
        for (Map.Entry<Subscription, SlowConsumerEntry> entry : this.slowConsumers.entrySet()) {
            if (entry.getKey().isSlowConsumer()) {
                if ((this.maxSlowDuration <= 0L || (long)entry.getValue().markCount * this.checkPeriod <= this.maxSlowDuration) && (this.maxSlowCount <= 0L || (long)entry.getValue().slowCount <= this.maxSlowCount)) continue;
                toAbort.put(entry.getKey(), entry.getValue());
                this.slowConsumers.remove(entry.getKey());
                continue;
            }
            LOG.info("Sub: " + entry.getKey().getConsumerInfo().getConsumerId() + " is no longer slow");
            this.slowConsumers.remove(entry.getKey());
        }
        this.abortSubscription(toAbort, this.abortConnection);
    }

    private void abortSubscription(Map<Subscription, SlowConsumerEntry> toAbort, boolean abortSubscriberConnection) {
        for (final Map.Entry<Subscription, SlowConsumerEntry> entry : toAbort.entrySet()) {
            ConnectionContext connectionContext = entry.getValue().context;
            if (connectionContext == null) continue;
            try {
                LOG.info("Aborting " + (abortSubscriberConnection ? "connection" : "consumer") + ",slow consumer:" + entry.getKey().getConsumerInfo().getConsumerId() + (this.maxSlowCount > 0L ? ",consumer slowCount:" + entry.getValue().slowCount + ",consumer maxSlowCount:" + this.maxSlowCount : "") + (this.maxSlowDuration > 0L ? ",consumer duration:" + (long)entry.getValue().markCount * this.checkPeriod + ",consumer maxSlowDuration:" + this.maxSlowDuration : ""));
                final Connection connection = connectionContext.getConnection();
                if (connection != null) {
                    if (abortSubscriberConnection) {
                        this.scheduler.executeAfterDelay(new Runnable(){

                            public void run() {
                                connection.serviceException(new InactivityIOException("Consumer was slow too often (>" + AbortSlowConsumerStrategy.this.maxSlowCount + ") or too long (>" + AbortSlowConsumerStrategy.this.maxSlowDuration + "): " + ((Subscription)entry.getKey()).getConsumerInfo().getConsumerId()));
                            }
                        }, 0L);
                        continue;
                    }
                    ConsumerControl stopConsumer = new ConsumerControl();
                    stopConsumer.setConsumerId(entry.getKey().getConsumerInfo().getConsumerId());
                    stopConsumer.setClose(true);
                    connection.dispatchAsync(stopConsumer);
                    continue;
                }
                LOG.debug("slowConsumer abort ignored, no connection in context:" + connectionContext);
            }
            catch (Exception e) {
                LOG.info("Exception on stopping " + (abortSubscriberConnection ? "connection" : "consumer") + " to abort slow consumer: " + entry.getKey(), e);
            }
        }
    }

    public void abortConsumer(Subscription sub, boolean abortSubscriberConnection) {
        if (sub != null) {
            SlowConsumerEntry entry = this.slowConsumers.remove(sub);
            if (entry != null) {
                HashMap<Subscription, SlowConsumerEntry> toAbort = new HashMap<Subscription, SlowConsumerEntry>();
                toAbort.put(sub, entry);
                this.abortSubscription(toAbort, abortSubscriberConnection);
            } else {
                LOG.warn("Cannot abort subscription as it no longer exists in the map of slow consumers: " + sub);
            }
        }
    }

    public long getMaxSlowCount() {
        return this.maxSlowCount;
    }

    public void setMaxSlowCount(long maxSlowCount) {
        this.maxSlowCount = maxSlowCount;
    }

    public long getMaxSlowDuration() {
        return this.maxSlowDuration;
    }

    public void setMaxSlowDuration(long maxSlowDuration) {
        this.maxSlowDuration = maxSlowDuration;
    }

    public long getCheckPeriod() {
        return this.checkPeriod;
    }

    public void setCheckPeriod(long checkPeriod) {
        this.checkPeriod = checkPeriod;
    }

    public boolean isAbortConnection() {
        return this.abortConnection;
    }

    public void setAbortConnection(boolean abortConnection) {
        this.abortConnection = abortConnection;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Map<Subscription, SlowConsumerEntry> getSlowConsumers() {
        return this.slowConsumers;
    }
}

