/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.policy;

import com.bes.mq.BESMQMessageAudit;
import com.bes.mq.broker.region.policy.DeadLetterStrategy;
import com.bes.mq.command.Message;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;

public abstract class AbstractDeadLetterStrategy
implements DeadLetterStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDeadLetterStrategy.class);
    private boolean processNonPersistent = false;
    private boolean processExpired = true;
    private boolean enableAudit = true;
    private BESMQMessageAudit messageAudit = new BESMQMessageAudit();

    public boolean isSendToDeadLetterQueue(Message message) {
        boolean result = false;
        if (message != null) {
            result = true;
            if (this.enableAudit && this.messageAudit.isDuplicate(message)) {
                result = false;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Not adding duplicate to DLQ: " + message.getMessageId() + ", dest: " + message.getDestination());
                }
            }
            if (!message.isPersistent() && !this.processNonPersistent) {
                result = false;
            }
            if (message.isExpired() && !this.processExpired) {
                result = false;
            }
        }
        return result;
    }

    public boolean isProcessExpired() {
        return this.processExpired;
    }

    public void setProcessExpired(boolean processExpired) {
        this.processExpired = processExpired;
    }

    public boolean isProcessNonPersistent() {
        return this.processNonPersistent;
    }

    public void setProcessNonPersistent(boolean processNonPersistent) {
        this.processNonPersistent = processNonPersistent;
    }

    public boolean isEnableAudit() {
        return this.enableAudit;
    }

    public void setEnableAudit(boolean enableAudit) {
        this.enableAudit = enableAudit;
    }
}

