/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.policy;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.SubscriptionRecovery;
import com.bes.mq.broker.region.Topic;
import com.bes.mq.broker.region.policy.SubscriptionRecoveryPolicy;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.Message;
import com.bes.mq.memory.list.DestinationBasedMessageList;
import com.bes.mq.memory.list.MessageList;
import com.bes.mq.memory.list.SimpleMessageList;
import java.util.List;

public class FixedSizedSubscriptionRecoveryPolicy
implements SubscriptionRecoveryPolicy {
    private MessageList buffer;
    private int maximumSize = 65536;
    private boolean useSharedBuffer = true;

    public SubscriptionRecoveryPolicy copy() {
        FixedSizedSubscriptionRecoveryPolicy rc = new FixedSizedSubscriptionRecoveryPolicy();
        rc.setMaximumSize(this.maximumSize);
        rc.setUseSharedBuffer(this.useSharedBuffer);
        return rc;
    }

    public boolean add(ConnectionContext context, MessageReference message) throws Exception {
        this.buffer.add(message);
        return true;
    }

    public void recover(ConnectionContext context, Topic topic, SubscriptionRecovery sub) throws Exception {
        List copy = this.buffer.getMessages(sub.getBESMQDestination());
        if (!copy.isEmpty()) {
            for (MessageReference node : copy) {
                sub.addRecoveredMessage(context, node);
            }
        }
    }

    public void start() throws Exception {
        this.buffer = this.createMessageList();
    }

    public void stop() throws Exception {
        this.buffer.clear();
    }

    public MessageList getBuffer() {
        return this.buffer;
    }

    public void setBuffer(MessageList buffer) {
        this.buffer = buffer;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    public boolean isUseSharedBuffer() {
        return this.useSharedBuffer;
    }

    public void setUseSharedBuffer(boolean useSharedBuffer) {
        this.useSharedBuffer = useSharedBuffer;
    }

    public Message[] browse(BESMQDestination destination) throws Exception {
        return this.buffer.browse(destination);
    }

    public void setBroker(Broker broker) {
    }

    protected MessageList createMessageList() {
        if (this.useSharedBuffer) {
            return new SimpleMessageList(this.maximumSize);
        }
        return new DestinationBasedMessageList(this.maximumSize);
    }
}

