/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.policy;

import com.bes.mq.broker.region.DurableTopicSubscription;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.broker.region.policy.AbstractDeadLetterStrategy;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQQueue;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.Message;

public class IndividualDeadLetterStrategy
extends AbstractDeadLetterStrategy {
    private String topicPrefix = "BESMQ.DLQ.TOPIC.";
    private String queuePrefix = "BESMQ.DLQ.QUEUE.";
    private String topicSuffix;
    private String queueSuffix;
    private boolean useQueueForQueueMessages = true;
    private boolean useQueueForTopicMessages = true;
    private boolean destinationPerDurableSubscriber;

    public BESMQDestination getDeadLetterQueueFor(Message message, Subscription subscription) {
        if (message.getDestination().isQueue()) {
            return this.createDestination(message, this.queuePrefix, this.queueSuffix, this.useQueueForQueueMessages, subscription);
        }
        return this.createDestination(message, this.topicPrefix, this.topicSuffix, this.useQueueForTopicMessages, subscription);
    }

    public String getQueuePrefix() {
        return this.queuePrefix;
    }

    public void setQueuePrefix(String queuePrefix) {
        this.queuePrefix = queuePrefix;
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.topicPrefix = topicPrefix;
    }

    public String getQueueSuffix() {
        return this.queueSuffix;
    }

    public void setQueueSuffix(String queueSuffix) {
        this.queueSuffix = queueSuffix;
    }

    public String getTopicSuffix() {
        return this.topicSuffix;
    }

    public void setTopicSuffix(String topicSuffix) {
        this.topicSuffix = topicSuffix;
    }

    public boolean isUseQueueForQueueMessages() {
        return this.useQueueForQueueMessages;
    }

    public void setUseQueueForQueueMessages(boolean useQueueForQueueMessages) {
        this.useQueueForQueueMessages = useQueueForQueueMessages;
    }

    public boolean isUseQueueForTopicMessages() {
        return this.useQueueForTopicMessages;
    }

    public void setUseQueueForTopicMessages(boolean useQueueForTopicMessages) {
        this.useQueueForTopicMessages = useQueueForTopicMessages;
    }

    public boolean isDestinationPerDurableSubscriber() {
        return this.destinationPerDurableSubscriber;
    }

    public void setDestinationPerDurableSubscriber(boolean destinationPerDurableSubscriber) {
        this.destinationPerDurableSubscriber = destinationPerDurableSubscriber;
    }

    protected BESMQDestination createDestination(Message message, String prefix, String suffix, boolean useQueue, Subscription subscription) {
        String name = null;
        name = message.getRegionDestination() != null && message.getRegionDestination().getBESMQDestination() != null && message.getRegionDestination().getBESMQDestination().getPhysicalName() != null && !message.getRegionDestination().getBESMQDestination().getPhysicalName().isEmpty() ? prefix + message.getRegionDestination().getBESMQDestination().getPhysicalName() : prefix + message.getDestination().getPhysicalName();
        if (this.destinationPerDurableSubscriber && subscription instanceof DurableTopicSubscription) {
            name = name + "." + ((DurableTopicSubscription)subscription).getSubscriptionKey();
        }
        if (suffix != null && !suffix.isEmpty()) {
            name = name + suffix;
        }
        if (useQueue) {
            return new BESMQQueue(name);
        }
        return new BESMQTopic(name);
    }
}

