/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.policy;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.SubscriptionRecovery;
import com.bes.mq.broker.region.Topic;
import com.bes.mq.broker.region.policy.SubscriptionRecoveryPolicy;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.Message;
import com.bes.mq.filter.DestinationFilter;
import java.util.ArrayList;

public class LastImageSubscriptionRecoveryPolicy
implements SubscriptionRecoveryPolicy {
    private volatile MessageReference lastImage;

    public boolean add(ConnectionContext context, MessageReference node) throws Exception {
        this.lastImage = node;
        return true;
    }

    public void recover(ConnectionContext context, Topic topic, SubscriptionRecovery sub) throws Exception {
        MessageReference node = this.lastImage;
        if (node != null) {
            sub.addRecoveredMessage(context, node);
        }
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public Message[] browse(BESMQDestination destination) throws Exception {
        DestinationFilter filter;
        ArrayList<Message> result = new ArrayList<Message>();
        if (this.lastImage != null && (filter = DestinationFilter.parseFilter(destination)).matches(this.lastImage.getMessage().getDestination())) {
            result.add(this.lastImage.getMessage());
        }
        return result.toArray(new Message[result.size()]);
    }

    public SubscriptionRecoveryPolicy copy() {
        return new LastImageSubscriptionRecoveryPolicy();
    }

    public void setBroker(Broker broker) {
    }
}

