/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.policy;

import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.broker.region.policy.SimpleDispatchPolicy;
import com.bes.mq.command.ConsumerId;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.filter.MessageEvaluationContext;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityNetworkDispatchPolicy
extends SimpleDispatchPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(PriorityNetworkDispatchPolicy.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dispatch(MessageReference node, MessageEvaluationContext msgContext, List<Subscription> consumers) throws Exception {
        ArrayList<Subscription> duplicateFreeSubs = new ArrayList<Subscription>();
        List<Subscription> list = consumers;
        synchronized (list) {
            for (Subscription sub : consumers) {
                ConsumerInfo info = sub.getConsumerInfo();
                if (info.isNetworkSubscription()) {
                    boolean highestPrioritySub = true;
                    Iterator it = duplicateFreeSubs.iterator();
                    while (it.hasNext()) {
                        Subscription candidate = (Subscription)it.next();
                        if (!this.matches(candidate, info)) continue;
                        if (this.hasLowerPriority(candidate, info)) {
                            it.remove();
                            continue;
                        }
                        highestPrioritySub = false;
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Ignoring lower priority: " + candidate + "[" + candidate.getConsumerInfo().getNetworkConsumerIds() + ", " + candidate.getConsumerInfo().getNetworkConsumerIds() + "] in favour of: " + sub + "[" + sub.getConsumerInfo().getNetworkConsumerIds() + ", " + sub.getConsumerInfo().getNetworkConsumerIds() + "]");
                    }
                    if (!highestPrioritySub) continue;
                    duplicateFreeSubs.add(sub);
                    continue;
                }
                duplicateFreeSubs.add(sub);
            }
        }
        return super.dispatch(node, msgContext, duplicateFreeSubs);
    }

    private boolean hasLowerPriority(Subscription candidate, ConsumerInfo info) {
        return candidate.getConsumerInfo().getPriority() < info.getPriority();
    }

    private boolean matches(Subscription candidate, ConsumerInfo info) {
        boolean matched = false;
        block0: for (ConsumerId candidateId : candidate.getConsumerInfo().getNetworkConsumerIds()) {
            for (ConsumerId subId : info.getNetworkConsumerIds()) {
                if (!candidateId.equals(subId)) continue;
                matched = true;
                continue block0;
            }
        }
        return matched;
    }
}

