/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.policy;

import com.bes.mq.BESMQMessageTransformation;
import com.bes.mq.broker.Broker;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.SubscriptionRecovery;
import com.bes.mq.broker.region.Topic;
import com.bes.mq.broker.region.policy.MessageQuery;
import com.bes.mq.broker.region.policy.SubscriptionRecoveryPolicy;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.command.ConnectionId;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageId;
import com.bes.mq.command.ProducerId;
import com.bes.mq.command.SessionId;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.util.IdGenerator;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.JMSException;
import javax.jms.MessageListener;

public class QueryBasedSubscriptionRecoveryPolicy
implements SubscriptionRecoveryPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(QueryBasedSubscriptionRecoveryPolicy.class);
    private MessageQuery query;
    private final AtomicLong messageSequence = new AtomicLong(0L);
    private final IdGenerator idGenerator = new IdGenerator();
    private final ProducerId producerId = this.createProducerId();

    public SubscriptionRecoveryPolicy copy() {
        QueryBasedSubscriptionRecoveryPolicy rc = new QueryBasedSubscriptionRecoveryPolicy();
        rc.setQuery(this.query);
        return rc;
    }

    public boolean add(ConnectionContext context, MessageReference message) throws Exception {
        return this.query.validateUpdate(message.getMessage());
    }

    public void recover(final ConnectionContext context, final Topic topic, final SubscriptionRecovery sub) throws Exception {
        if (this.query != null) {
            BESMQDestination destination = sub.getBESMQDestination();
            this.query.execute(destination, new MessageListener(){

                public void onMessage(javax.jms.Message message) {
                    QueryBasedSubscriptionRecoveryPolicy.this.dispatchInitialMessage(message, topic, context, sub);
                }
            });
        }
    }

    public void start() throws Exception {
        if (this.query == null) {
            throw new IllegalArgumentException("No query property configured");
        }
    }

    public void stop() throws Exception {
    }

    public MessageQuery getQuery() {
        return this.query;
    }

    public void setQuery(MessageQuery query) {
        this.query = query;
    }

    public Message[] browse(BESMQDestination dest) throws Exception {
        return new Message[0];
    }

    public void setBroker(Broker broker) {
    }

    protected void dispatchInitialMessage(javax.jms.Message message, Destination regionDestination, ConnectionContext context, SubscriptionRecovery sub) {
        try {
            BESMQMessage activeMessage = BESMQMessageTransformation.transformMessage(message, null);
            BESMQDestination destination = activeMessage.getDestination();
            if (destination == null) {
                destination = sub.getBESMQDestination();
                activeMessage.setDestination(destination);
            }
            activeMessage.setRegionDestination(regionDestination);
            this.configure(activeMessage);
            sub.addRecoveredMessage(context, activeMessage);
        }
        catch (Throwable e) {
            LOG.warn("Failed to dispatch initial message: " + message + " into subscription. Reason: " + e, e);
        }
    }

    protected void configure(BESMQMessage msg) throws JMSException {
        long sequenceNumber = this.messageSequence.incrementAndGet();
        msg.setMessageId(new MessageId(this.producerId, sequenceNumber));
        msg.onSend();
        msg.setProducerId(this.producerId);
    }

    protected ProducerId createProducerId() {
        String id = this.idGenerator.generateId();
        ConnectionId connectionId = new ConnectionId(id);
        SessionId sessionId = new SessionId(connectionId, 1L);
        return new ProducerId(sessionId, 1L);
    }
}

