/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.policy;

import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.broker.region.policy.DispatchPolicy;
import com.bes.mq.filter.MessageEvaluationContext;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoundRobinDispatchPolicy
implements DispatchPolicy {
    static final Logger LOG = LoggerFactory.getLogger(RoundRobinDispatchPolicy.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dispatch(MessageReference node, MessageEvaluationContext msgContext, List<Subscription> consumers) throws Exception {
        int count = 0;
        Subscription firstMatchingConsumer = null;
        List<Subscription> list = consumers;
        synchronized (list) {
            for (Subscription sub : consumers) {
                if (!sub.matches(node, msgContext)) {
                    sub.unmatched(node);
                    continue;
                }
                if (firstMatchingConsumer == null) {
                    firstMatchingConsumer = sub;
                }
                sub.add(node);
                ++count;
            }
            if (firstMatchingConsumer != null) {
                try {
                    consumers.remove(firstMatchingConsumer);
                    consumers.add(firstMatchingConsumer);
                }
                catch (Throwable bestEffort) {
                    // empty catch block
                }
            }
        }
        return count > 0;
    }
}

