/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.policy;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.SubscriptionRecovery;
import com.bes.mq.broker.region.Topic;
import com.bes.mq.broker.region.policy.SubscriptionRecoveryPolicy;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.Message;
import com.bes.mq.filter.DestinationFilter;
import com.bes.mq.thread.Scheduler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class TimedSubscriptionRecoveryPolicy
implements SubscriptionRecoveryPolicy {
    private static final int GC_INTERVAL = 1000;
    private Scheduler scheduler;
    private final List<TimestampWrapper> buffer = Collections.synchronizedList(new LinkedList());
    private volatile long lastGCRun = System.currentTimeMillis();
    private long recoverDuration = 60000L;
    private final Runnable gcTask = new Runnable(){

        public void run() {
            TimedSubscriptionRecoveryPolicy.this.gc();
        }
    };

    public SubscriptionRecoveryPolicy copy() {
        TimedSubscriptionRecoveryPolicy rc = new TimedSubscriptionRecoveryPolicy();
        rc.setRecoverDuration(this.recoverDuration);
        return rc;
    }

    public boolean add(ConnectionContext context, MessageReference message) throws Exception {
        this.buffer.add(new TimestampWrapper(message, this.lastGCRun));
        return true;
    }

    public void recover(ConnectionContext context, Topic topic, SubscriptionRecovery sub) throws Exception {
        ArrayList<TimestampWrapper> copy = new ArrayList<TimestampWrapper>(this.buffer);
        if (!copy.isEmpty()) {
            for (TimestampWrapper timestampWrapper : copy) {
                MessageReference message = timestampWrapper.message;
                sub.addRecoveredMessage(context, message);
            }
        }
    }

    public void setBroker(Broker broker) {
        this.scheduler = broker.getScheduler();
    }

    public void start() throws Exception {
        this.scheduler.executePeriodically(this.gcTask, 1000L);
    }

    public void stop() throws Exception {
        this.scheduler.cancel(this.gcTask);
    }

    public void gc() {
        this.lastGCRun = System.currentTimeMillis();
        while (this.buffer.size() > 0) {
            TimestampWrapper timestampWrapper = this.buffer.get(0);
            if (this.lastGCRun <= timestampWrapper.timestamp + this.recoverDuration) break;
            this.buffer.remove(0);
        }
    }

    public long getRecoverDuration() {
        return this.recoverDuration;
    }

    public void setRecoverDuration(long recoverDuration) {
        this.recoverDuration = recoverDuration;
    }

    public Message[] browse(BESMQDestination destination) throws Exception {
        ArrayList<Message> result = new ArrayList<Message>();
        ArrayList<TimestampWrapper> copy = new ArrayList<TimestampWrapper>(this.buffer);
        DestinationFilter filter = DestinationFilter.parseFilter(destination);
        for (TimestampWrapper timestampWrapper : copy) {
            MessageReference ref = timestampWrapper.message;
            Message message = ref.getMessage();
            if (!filter.matches(message.getDestination())) continue;
            result.add(message);
        }
        return result.toArray(new Message[result.size()]);
    }

    static class TimestampWrapper {
        public MessageReference message;
        public long timestamp;

        public TimestampWrapper(MessageReference message, long timestamp) {
            this.message = message;
            this.timestamp = timestamp;
        }
    }
}

