/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.policy;

import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.policy.MessageEvictionStrategySupport;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class UniquePropertyMessageEvictionStrategy
extends MessageEvictionStrategySupport {
    private static final Logger LOG = LoggerFactory.getLogger(UniquePropertyMessageEvictionStrategy.class);
    protected String propertyName;

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public MessageReference[] evictMessages(LinkedList messages) throws IOException {
        MessageReference oldest = (MessageReference)messages.getFirst();
        HashMap<Object, MessageReference> pivots = new HashMap<Object, MessageReference>();
        for (MessageReference reference : messages) {
            if (this.propertyName == null || reference.getMessage().getProperty(this.propertyName) == null) continue;
            Object key = reference.getMessage().getProperty(this.propertyName);
            if (pivots.containsKey(key)) {
                MessageReference pivot = (MessageReference)pivots.get(key);
                if (reference.getMessage().getTimestamp() >= pivot.getMessage().getTimestamp()) continue;
                pivots.put(key, reference);
                continue;
            }
            pivots.put(key, reference);
        }
        if (!pivots.isEmpty()) {
            ArrayList<MessageReference> messageReferences = new ArrayList<MessageReference>();
            for (MessageReference reference : pivots.values()) {
                messageReferences.add(reference);
            }
            return messageReferences.toArray(new MessageReference[0]);
        }
        return new MessageReference[]{oldest};
    }
}

