/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.virtual;

import com.bes.mq.broker.ProducerBrokerExchange;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.DestinationFilter;
import com.bes.mq.broker.region.virtual.FilteredDestination;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.Message;
import com.bes.mq.filter.MessageEvaluationContext;
import com.bes.mq.filter.NonCachedMessageEvaluationContext;
import java.util.Collection;
import java.util.Iterator;

public class CompositeDestinationFilter
extends DestinationFilter {
    private Collection forwardDestinations;
    private boolean forwardOnly;
    private boolean copyMessage;

    public CompositeDestinationFilter(Destination next, Collection forwardDestinations, boolean forwardOnly, boolean copyMessage) {
        super(next);
        this.forwardDestinations = forwardDestinations;
        this.forwardOnly = forwardOnly;
        this.copyMessage = copyMessage;
    }

    public void send(ProducerBrokerExchange context, Message message) throws Exception {
        NonCachedMessageEvaluationContext messageContext = null;
        Iterator iter = this.forwardDestinations.iterator();
        while (iter.hasNext()) {
            Message forwarded_message;
            BESMQDestination destination = null;
            Object value = iter.next();
            if (value instanceof FilteredDestination) {
                FilteredDestination filteredDestination = (FilteredDestination)value;
                if (messageContext == null) {
                    messageContext = new NonCachedMessageEvaluationContext();
                    ((MessageEvaluationContext)messageContext).setMessageReference(message);
                }
                messageContext.setDestination(filteredDestination.getDestination());
                if (filteredDestination.matches(messageContext)) {
                    destination = filteredDestination.getDestination();
                }
            } else if (value instanceof BESMQDestination) {
                destination = (BESMQDestination)value;
            }
            if (destination == null) continue;
            if (this.copyMessage) {
                forwarded_message = message.copy();
                forwarded_message.setDestination(destination);
            } else {
                forwarded_message = message;
            }
            this.send(context, forwarded_message, destination);
        }
        if (!this.forwardOnly) {
            super.send(context, message);
        }
    }
}

