/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.virtual;

import com.bes.mq.command.BESMQDestination;
import com.bes.mq.filter.BooleanExpression;
import com.bes.mq.filter.MessageEvaluationContext;
import com.bes.mq.selector.SelectorParser;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;

public class FilteredDestination {
    private BESMQDestination destination;
    private String selector;
    private BooleanExpression filter;

    public boolean matches(MessageEvaluationContext context) throws JMSException {
        BooleanExpression booleanExpression = this.getFilter();
        if (booleanExpression == null) {
            return false;
        }
        return booleanExpression.matches(context);
    }

    public BESMQDestination getDestination() {
        return this.destination;
    }

    public void setDestination(BESMQDestination destination) {
        this.destination = destination;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) throws InvalidSelectorException {
        this.selector = selector;
        this.setFilter(SelectorParser.parse(selector));
    }

    public BooleanExpression getFilter() {
        return this.filter;
    }

    public void setFilter(BooleanExpression filter) {
        this.filter = filter;
    }

    public void setQueue(String queue) {
        this.setDestination(BESMQDestination.createDestination(queue, (byte)1));
    }

    public void setTopic(String topic) {
        this.setDestination(BESMQDestination.createDestination(topic, (byte)2));
    }
}

