/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.virtual;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.BrokerServiceAware;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.ProducerBrokerExchange;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.DestinationFilter;
import com.bes.mq.broker.region.DestinationInterceptor;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.Message;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;

public class MirroredQueue
implements DestinationInterceptor,
BrokerServiceAware {
    private static final transient Logger LOG = LoggerFactory.getLogger(MirroredQueue.class);
    private String prefix = "VirtualTopic.Mirror.";
    private String postfix = "";
    private boolean copyMessage = true;
    private String name;
    private BrokerService brokerService;

    public Destination intercept(final Destination destination) {
        if (destination.getBESMQDestination().isQueue() && destination.getBESMQDestination().getPhysicalName().equals(this.name) && (!destination.getBESMQDestination().isTemporary() || this.brokerService.isUseTempMirroredQueues())) {
            try {
                final Destination mirrorDestination = this.getMirrorDestination(destination);
                if (mirrorDestination != null) {
                    return new DestinationFilter(destination){

                        public void send(ProducerBrokerExchange context, Message message) throws Exception {
                            message.setDestination(mirrorDestination.getBESMQDestination());
                            mirrorDestination.send(context, message);
                            if (MirroredQueue.this.isCopyMessage()) {
                                message = message.copy();
                            }
                            message.setDestination(destination.getBESMQDestination());
                            message.setMemoryUsage(null);
                            super.send(context, message);
                        }
                    };
                }
            }
            catch (Exception e) {
                LOG.error("Failed to lookup the mirror destination for: " + destination + ". Reason: " + e, e);
            }
        }
        return destination;
    }

    public void remove(Destination destination) {
        if (this.brokerService == null) {
            throw new IllegalArgumentException("No brokerService injected!");
        }
        BESMQDestination topic = this.getMirrorTopic(destination.getBESMQDestination());
        if (topic != null) {
            try {
                this.brokerService.removeDestination(topic);
            }
            catch (Exception e) {
                LOG.error("Failed to remove mirror destination for " + destination + ". Reason: " + e, e);
            }
        }
    }

    public void create(Broker broker, ConnectionContext context, BESMQDestination destination) {
    }

    public String getPostfix() {
        return this.postfix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isCopyMessage() {
        return this.copyMessage;
    }

    public void setCopyMessage(boolean copyMessage) {
        this.copyMessage = copyMessage;
    }

    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    protected Destination getMirrorDestination(Destination destination) throws Exception {
        if (this.brokerService == null) {
            throw new IllegalArgumentException("No brokerService injected!");
        }
        BESMQDestination topic = this.getMirrorTopic(destination.getBESMQDestination());
        return this.brokerService.getDestination(topic);
    }

    protected BESMQDestination getMirrorTopic(BESMQDestination original) {
        return new BESMQTopic(this.prefix + original.getPhysicalName() + this.postfix);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

