/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.virtual;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.ProducerBrokerExchange;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.DestinationFilter;
import com.bes.mq.broker.region.DestinationInterceptor;
import com.bes.mq.broker.region.virtual.VirtualDestination;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.Message;
import com.bes.mq.filter.DestinationMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualDestinationInterceptor
implements DestinationInterceptor {
    private DestinationMap destinationMap = new DestinationMap();
    private VirtualDestination[] virtualDestinations;
    private String name;

    @Override
    public synchronized Destination intercept(Destination destination) {
        Set matchingDestinations = this.destinationMap.get(destination.getBESMQDestination());
        ArrayList<Destination> destinations = new ArrayList<Destination>();
        for (VirtualDestination virtualDestination : matchingDestinations) {
            Destination newDestination = virtualDestination.intercept(destination);
            destinations.add(newDestination);
        }
        if (!destinations.isEmpty()) {
            if (destinations.size() == 1) {
                return (Destination)destinations.get(0);
            }
            return this.createCompositeDestination(destination, destinations);
        }
        return destination;
    }

    @Override
    public synchronized void create(Broker broker, ConnectionContext context, BESMQDestination destination) throws Exception {
        for (VirtualDestination virt : this.virtualDestinations) {
            virt.create(broker, context, destination);
        }
    }

    @Override
    public synchronized void remove(Destination destination) {
        BESMQDestination removeDestination = destination.getBESMQDestination();
        Set matchingDestinations = this.destinationMap.get(removeDestination);
        if (!matchingDestinations.isEmpty()) {
            ArrayList<VirtualDestination> virtualDestinationList = new ArrayList<VirtualDestination>();
            for (VirtualDestination virt : this.virtualDestinations) {
                if (!virt.getVirtualDestination().equals(removeDestination)) {
                    virtualDestinationList.add(virt);
                    continue;
                }
                virt.remove(destination);
            }
            this.virtualDestinations = virtualDestinationList.toArray(new VirtualDestination[0]);
            this.destinationMap.removeAll(removeDestination);
        }
    }

    public synchronized VirtualDestination[] getVirtualDestinations() {
        return this.virtualDestinations;
    }

    public synchronized void setVirtualDestinations(VirtualDestination[] virtualDestinations) {
        this.destinationMap = new DestinationMap();
        this.virtualDestinations = virtualDestinations;
        for (int i = 0; i < virtualDestinations.length; ++i) {
            VirtualDestination virtualDestination = virtualDestinations[i];
            this.destinationMap.put(virtualDestination.getVirtualDestination(), virtualDestination);
        }
    }

    protected synchronized Destination createCompositeDestination(Destination destination, final List<Destination> destinations) {
        return new DestinationFilter(destination){

            public void send(ProducerBrokerExchange context, Message messageSend) throws Exception {
                for (Destination destination : destinations) {
                    destination.send(context, messageSend);
                }
            }
        };
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

