/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.virtual;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.virtual.SelectorAwareVirtualTopicInterceptor;
import com.bes.mq.broker.region.virtual.VirtualDestination;
import com.bes.mq.broker.region.virtual.VirtualTopicInterceptor;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQQueue;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.filter.DestinationFilter;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import java.util.Set;

public class VirtualTopic
implements VirtualDestination {
    private static final transient Logger LOG = LoggerFactory.getLogger(VirtualDestination.class);
    private String prefix = "Consumer.*.";
    private String postfix = "";
    private String name = ">";
    private boolean selectorAware = false;
    private boolean local = false;
    private BrokerService brokerService;

    public BESMQDestination getVirtualDestination() {
        return new BESMQTopic(this.getName());
    }

    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    public Destination intercept(Destination destination) {
        return this.selectorAware ? new SelectorAwareVirtualTopicInterceptor(destination, this.getPrefix(), this.getPostfix(), this.isLocal()) : new VirtualTopicInterceptor(destination, this.getPrefix(), this.getPostfix(), this.isLocal());
    }

    public void create(Broker broker, ConnectionContext context, BESMQDestination destination) throws Exception {
        DestinationFilter filter;
        if (destination.isQueue() && destination.isPattern() && broker.getDestinations(destination).isEmpty() && (filter = DestinationFilter.parseFilter(new BESMQQueue(this.prefix + ">"))).matches(destination)) {
            broker.addDestination(context, destination, false);
        }
    }

    public void remove(Destination destination) {
        if (this.brokerService == null) {
            throw new IllegalArgumentException("No brokerService injected!");
        }
        BESMQQueue wildcardQueue = new BESMQQueue(this.prefix + destination.getBESMQDestination().getPhysicalName() + this.postfix);
        Set<Destination> virtualQueues = this.brokerService.getRegionBroker().getDestinations(wildcardQueue);
        if (virtualQueues != null) {
            for (Destination dest : virtualQueues) {
                try {
                    this.brokerService.removeDestination(dest.getBESMQDestination());
                }
                catch (Exception e) {
                    LOG.error("Failed to remove virtual destination for " + destination + ". Reason: " + e, e);
                }
            }
        }
    }

    public String getPostfix() {
        return this.postfix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSelectorAware(boolean selectorAware) {
        this.selectorAware = selectorAware;
    }

    public boolean isSelectorAware() {
        return this.selectorAware;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }
}

