/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.virtual;

import com.bes.mq.broker.ProducerBrokerExchange;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.DestinationFilter;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQQueue;
import com.bes.mq.command.Message;
import com.bes.mq.util.LRUCache;

public class VirtualTopicInterceptor
extends DestinationFilter {
    private String prefix;
    private String postfix;
    private boolean local;
    private LRUCache<BESMQDestination, BESMQQueue> cache = new LRUCache();

    public VirtualTopicInterceptor(Destination next, String prefix, String postfix, boolean local) {
        super(next);
        this.prefix = prefix;
        this.postfix = postfix;
        this.local = local;
    }

    public void send(ProducerBrokerExchange context, Message message) throws Exception {
        if (!(message.isNotification() || this.local && message.getBrokerPath() != null)) {
            BESMQDestination queueConsumers = this.getQueueConsumersWildcard(message.getDestination());
            this.send(context, message, queueConsumers);
        }
        super.send(context, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BESMQDestination getQueueConsumersWildcard(BESMQDestination original) {
        BESMQQueue queue;
        LRUCache<BESMQDestination, BESMQQueue> lRUCache = this.cache;
        synchronized (lRUCache) {
            queue = (BESMQQueue)this.cache.get(original);
            if (queue == null) {
                queue = new BESMQQueue(this.prefix + original.getPhysicalName() + this.postfix);
                this.cache.put(original, queue);
            }
        }
        return queue;
    }
}

