/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.scheduler;

import com.bes.hsdb.index.BTreeIndex;
import com.bes.hsdb.journal.Location;
import com.bes.hsdb.page.Transaction;
import com.bes.hsdb.util.ByteSequence;
import com.bes.hsdb.util.LongMarshaller;
import com.bes.hsdb.util.Marshaller;
import com.bes.hsdb.util.VariableMarshaller;
import com.bes.mq.broker.scheduler.CronParser;
import com.bes.mq.broker.scheduler.Job;
import com.bes.mq.broker.scheduler.JobImpl;
import com.bes.mq.broker.scheduler.JobListener;
import com.bes.mq.broker.scheduler.JobLocation;
import com.bes.mq.broker.scheduler.JobScheduler;
import com.bes.mq.broker.scheduler.JobSchedulerStore;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.util.IdGenerator;
import com.bes.mq.util.ServiceStopper;
import com.bes.mq.util.ServiceSupport;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.MessageFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JobSchedulerImpl
extends ServiceSupport
implements Runnable,
JobScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(JobSchedulerImpl.class);
    final JobSchedulerStore store;
    private final AtomicBoolean running = new AtomicBoolean();
    private String name;
    BTreeIndex<Long, List<JobLocation>> index;
    private Thread thread;
    private final List<JobListener> jobListeners = new CopyOnWriteArrayList<JobListener>();
    private static final IdGenerator ID_GENERATOR = new IdGenerator();
    private final ScheduleTime scheduleTime = new ScheduleTime();

    JobSchedulerImpl(JobSchedulerStore store) {
        this.store = store;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addListener(JobListener l) {
        this.jobListeners.add(l);
    }

    @Override
    public void removeListener(JobListener l) {
        this.jobListeners.remove(l);
    }

    @Override
    public synchronized void schedule(final String jobId, final ByteSequence payload, final long delay) throws IOException {
        this.store.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

            public void execute(Transaction tx) throws IOException {
                JobSchedulerImpl.this.schedule(tx, jobId, payload, "", 0L, delay, 0);
            }
        });
    }

    @Override
    public synchronized void schedule(final String jobId, final ByteSequence payload, final String cronEntry) throws Exception {
        this.store.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

            public void execute(Transaction tx) throws IOException {
                JobSchedulerImpl.this.schedule(tx, jobId, payload, cronEntry, 0L, 0L, 0);
            }
        });
    }

    @Override
    public synchronized void schedule(final String jobId, final ByteSequence payload, final String cronEntry, final long delay, final long period, final int repeat) throws IOException {
        this.store.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

            public void execute(Transaction tx) throws IOException {
                JobSchedulerImpl.this.schedule(tx, jobId, payload, cronEntry, delay, period, repeat);
            }
        });
    }

    @Override
    public synchronized void remove(final long time) throws IOException {
        this.store.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

            public void execute(Transaction tx) throws IOException {
                JobSchedulerImpl.this.remove(tx, time);
            }
        });
    }

    synchronized void removeFromIndex(final long time, final String jobId) throws IOException {
        this.store.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

            public void execute(Transaction tx) throws IOException {
                JobSchedulerImpl.this.removeFromIndex(tx, time, jobId);
            }
        });
    }

    public synchronized void remove(final long time, final String jobId) throws IOException {
        this.store.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

            public void execute(Transaction tx) throws IOException {
                JobSchedulerImpl.this.remove(tx, time, jobId);
            }
        });
    }

    @Override
    public synchronized void remove(final String jobId) throws IOException {
        this.store.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

            public void execute(Transaction tx) throws IOException {
                JobSchedulerImpl.this.remove(tx, jobId);
            }
        });
    }

    @Override
    public synchronized long getNextScheduleTime() throws IOException {
        Map.Entry first = this.index.getFirst(this.store.getPageFile().tx());
        return first != null ? (Long)first.getKey() : -1L;
    }

    @Override
    public synchronized List<Job> getNextScheduleJobs() throws IOException {
        final ArrayList<Job> result = new ArrayList<Job>();
        this.store.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

            public void execute(Transaction tx) throws IOException {
                Map.Entry first = JobSchedulerImpl.this.index.getFirst(JobSchedulerImpl.this.store.getPageFile().tx());
                if (first != null) {
                    for (JobLocation jl : (List)first.getValue()) {
                        ByteSequence bs = JobSchedulerImpl.this.getPayload(jl.getLocation());
                        JobImpl job = new JobImpl(jl, bs);
                        result.add(job);
                    }
                }
            }
        });
        return result;
    }

    @Override
    public synchronized List<Job> getAllJobs() throws IOException {
        final ArrayList<Job> result = new ArrayList<Job>();
        this.store.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

            public void execute(Transaction tx) throws IOException {
                Map.Entry next;
                Iterator iter = JobSchedulerImpl.this.index.iterator(JobSchedulerImpl.this.store.getPageFile().tx());
                while (iter.hasNext() && (next = (Map.Entry)iter.next()) != null) {
                    for (JobLocation jl : (List)next.getValue()) {
                        ByteSequence bs = JobSchedulerImpl.this.getPayload(jl.getLocation());
                        JobImpl job = new JobImpl(jl, bs);
                        result.add(job);
                    }
                }
            }
        });
        return result;
    }

    @Override
    public synchronized List<Job> getAllJobs(final long start, final long finish) throws IOException {
        final ArrayList<Job> result = new ArrayList<Job>();
        this.store.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

            public void execute(Transaction tx) throws IOException {
                Map.Entry next;
                Iterator iter = JobSchedulerImpl.this.index.iterator(JobSchedulerImpl.this.store.getPageFile().tx(), (Object)start);
                while (iter.hasNext() && (next = (Map.Entry)iter.next()) != null && (Long)next.getKey() <= finish) {
                    for (JobLocation jl : (List)next.getValue()) {
                        ByteSequence bs = JobSchedulerImpl.this.getPayload(jl.getLocation());
                        JobImpl job = new JobImpl(jl, bs);
                        result.add(job);
                    }
                }
            }
        });
        return result;
    }

    @Override
    public synchronized void removeAllJobs() throws IOException {
        this.store.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

            public void execute(Transaction tx) throws IOException {
                JobSchedulerImpl.this.destroy(tx);
            }
        });
    }

    @Override
    public synchronized void removeAllJobs(final long start, final long finish) throws IOException {
        this.store.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

            public void execute(Transaction tx) throws IOException {
                JobSchedulerImpl.this.destroy(tx, start, finish);
            }
        });
    }

    ByteSequence getPayload(Location location) throws IllegalStateException, IOException {
        return this.store.getPayload(location);
    }

    void schedule(Transaction tx, String jobId, ByteSequence payload, String cronEntry, long delay, long period, int repeat) throws IOException {
        long startTime = System.currentTimeMillis();
        startTime = startTime / 1000L * 1000L;
        long time = 0L;
        if (cronEntry != null && cronEntry.length() > 0) {
            try {
                time = CronParser.getNextScheduledTime(cronEntry, startTime);
            }
            catch (MessageFormatException e) {
                throw new IOException(e.getMessage());
            }
        }
        if (time == 0L) {
            time = startTime;
        }
        time = delay > 0L ? (time += delay) : (time += period);
        Location location = this.store.write(payload, false);
        JobLocation jobLocation = new JobLocation(location);
        this.store.incrementJournalCount(tx, location);
        jobLocation.setJobId(jobId);
        jobLocation.setStartTime(startTime);
        jobLocation.setCronEntry(cronEntry);
        jobLocation.setDelay(delay);
        jobLocation.setPeriod(period);
        jobLocation.setRepeat(repeat);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scheduling " + jobLocation);
        }
        this.storeJob(tx, jobLocation, time);
        this.scheduleTime.newJob();
    }

    synchronized void storeJob(final JobLocation jobLocation, final long nextExecutionTime) throws IOException {
        this.store.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

            public void execute(Transaction tx) throws IOException {
                JobSchedulerImpl.this.storeJob(tx, jobLocation, nextExecutionTime);
            }
        });
    }

    void storeJob(Transaction tx, JobLocation jobLocation, long nextExecutionTime) throws IOException {
        List<JobLocation> values = null;
        jobLocation.setNextTime(nextExecutionTime);
        if (this.index.containsKey(tx, (Object)nextExecutionTime)) {
            values = (List)this.index.remove(tx, (Object)nextExecutionTime);
        }
        if (values == null) {
            values = new ArrayList<JobLocation>();
        }
        values.add(jobLocation);
        this.index.put(tx, (Object)nextExecutionTime, values);
    }

    void remove(Transaction tx, long time, String jobId) throws IOException {
        JobLocation result = this.removeFromIndex(tx, time, jobId);
        if (result != null) {
            this.store.decrementJournalCount(tx, result.getLocation());
        }
    }

    JobLocation removeFromIndex(Transaction tx, long time, String jobId) throws IOException {
        JobLocation result = null;
        List values = (List)this.index.remove(tx, (Object)time);
        if (values != null) {
            for (int i = 0; i < values.size(); ++i) {
                JobLocation jl = (JobLocation)values.get(i);
                if (!jl.getJobId().equals(jobId)) continue;
                values.remove(i);
                if (!values.isEmpty()) {
                    this.index.put(tx, (Object)time, (Object)values);
                }
                result = jl;
                break;
            }
        }
        return result;
    }

    void remove(Transaction tx, long time) throws IOException {
        List values = (List)this.index.remove(tx, (Object)time);
        if (values != null) {
            for (JobLocation jl : values) {
                this.store.decrementJournalCount(tx, jl.getLocation());
            }
        }
    }

    void remove(Transaction tx, String id) throws IOException {
        Iterator i = this.index.iterator(tx);
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            List values = (List)entry.getValue();
            if (values == null) continue;
            for (JobLocation jl : values) {
                if (!jl.getJobId().equals(id)) continue;
                this.remove(tx, (Long)entry.getKey(), id);
                return;
            }
        }
    }

    synchronized void destroy(Transaction tx) throws IOException {
        ArrayList keys = new ArrayList();
        Iterator i = this.index.iterator(tx);
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            keys.add(entry.getKey());
            List values = (List)entry.getValue();
            if (values == null) continue;
            for (JobLocation jl : values) {
                this.store.decrementJournalCount(tx, jl.getLocation());
            }
        }
        for (Long l : keys) {
            this.index.remove(tx, (Object)l);
        }
    }

    synchronized void destroy(Transaction tx, long start, long finish) throws IOException {
        Map.Entry entry;
        ArrayList keys = new ArrayList();
        Iterator i = this.index.iterator(tx, (Object)start);
        while (i.hasNext() && (Long)(entry = (Map.Entry)i.next()).getKey() <= finish) {
            keys.add(entry.getKey());
            List values = (List)entry.getValue();
            if (values == null) continue;
            for (JobLocation jl : values) {
                this.store.decrementJournalCount(tx, jl.getLocation());
            }
        }
        for (Long l : keys) {
            this.index.remove(tx, (Object)l);
        }
    }

    private synchronized Map.Entry<Long, List<JobLocation>> getNextToSchedule() throws IOException {
        if (!this.store.isStopped() && !this.store.isStopping()) {
            Map.Entry first = this.index.getFirst(this.store.getPageFile().tx());
            return first;
        }
        return null;
    }

    void fireJob(JobLocation job) throws IllegalStateException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Firing " + job);
        }
        ByteSequence bs = this.store.getPayload(job.getLocation());
        for (JobListener l : this.jobListeners) {
            l.scheduledJob(job.getJobId(), bs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.mainLoop();
        }
        catch (Throwable e) {
            if (this.running.get() && this.isStarted()) {
                LOG.error(this + " Caught exception in mainloop", e);
            }
        }
        finally {
            if (this.running.get()) {
                try {
                    this.stop();
                }
                catch (Exception e) {
                    LOG.error("Failed to stop " + this);
                }
            }
        }
    }

    public String toString() {
        return "JobScheduler:" + this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mainLoop() {
        while (this.running.get()) {
            this.scheduleTime.clearNewJob();
            try {
                long currentTime = System.currentTimeMillis();
                JobSchedulerImpl jobSchedulerImpl = this;
                synchronized (jobSchedulerImpl) {
                    Map.Entry<Long, List<JobLocation>> first = this.getNextToSchedule();
                    if (first != null) {
                        ArrayList list = new ArrayList(first.getValue());
                        long executionTime = first.getKey();
                        long nextExecutionTime = 0L;
                        if (executionTime <= currentTime) {
                            long timeUntilNextScheduled;
                            for (JobLocation job : list) {
                                int repeat = job.getRepeat();
                                nextExecutionTime = this.calculateNextExecutionTime(job, currentTime, repeat);
                                long waitTime = nextExecutionTime - currentTime;
                                this.scheduleTime.setWaitTime(waitTime);
                                if (!job.isCron()) {
                                    this.fireJob(job);
                                    if (repeat == 0) continue;
                                    job.setRepeat(--repeat);
                                    this.removeFromIndex(executionTime, job.getJobId());
                                    this.storeJob(job, nextExecutionTime);
                                    continue;
                                }
                                if (repeat == 0) {
                                    this.fireJob(job);
                                }
                                if (nextExecutionTime <= currentTime) continue;
                                this.removeFromIndex(executionTime, job.getJobId());
                                this.storeJob(job, nextExecutionTime);
                                if (repeat == 0) continue;
                                String jobId = ID_GENERATOR.generateId();
                                ByteSequence payload = this.getPayload(job.getLocation());
                                this.schedule(jobId, payload, "", job.getDelay(), job.getPeriod(), job.getRepeat());
                                waitTime = job.getDelay() != 0L ? job.getDelay() : job.getPeriod();
                                this.scheduleTime.setWaitTime(waitTime);
                            }
                            this.remove(executionTime);
                            Map.Entry<Long, List<JobLocation>> nextUp = this.getNextToSchedule();
                            if (nextUp != null && (timeUntilNextScheduled = nextUp.getKey() - currentTime) < this.scheduleTime.getWaitTime()) {
                                this.scheduleTime.setWaitTime(timeUntilNextScheduled);
                            }
                        } else {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Not yet time to execute the job, waiting " + (executionTime - currentTime) + " ms");
                            }
                            this.scheduleTime.setWaitTime(executionTime - currentTime);
                        }
                    }
                }
                this.scheduleTime.pause();
            }
            catch (Exception ioe) {
                LOG.error(this.name + " Failed to schedule job", ioe);
                try {
                    this.store.stop();
                }
                catch (Exception e) {
                    LOG.error(this.name + " Failed to shutdown JobSchedulerStore", e);
                }
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.running.set(true);
        this.thread = new Thread((Runnable)this, "JobScheduler:" + this.name);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
        this.running.set(false);
        this.scheduleTime.wakeup();
        Thread t = this.thread;
        if (t != null) {
            t.join(1000L);
        }
    }

    long calculateNextExecutionTime(JobLocation job, long currentTime, int repeat) throws MessageFormatException {
        long result = currentTime;
        String cron = job.getCronEntry();
        if (cron != null && cron.length() > 0) {
            result = CronParser.getNextScheduledTime(cron, result);
        } else if (job.getRepeat() != 0) {
            result += job.getPeriod();
        }
        return result;
    }

    void createIndexes(Transaction tx) throws IOException {
        this.index = new BTreeIndex(this.store.getPageFile(), tx.allocate().getPageId());
    }

    void load(Transaction tx) throws IOException {
        this.index.setKeyMarshaller((Marshaller)LongMarshaller.INSTANCE);
        this.index.setValueMarshaller((Marshaller)ValueMarshaller.INSTANCE);
        this.index.load(tx);
    }

    void read(DataInput in) throws IOException {
        this.name = in.readUTF();
        this.index = new BTreeIndex(this.store.getPageFile(), in.readLong());
        this.index.setKeyMarshaller((Marshaller)LongMarshaller.INSTANCE);
        this.index.setValueMarshaller((Marshaller)ValueMarshaller.INSTANCE);
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeLong(this.index.getPageId());
    }

    static class ScheduleTime {
        private final int DEFAULT_WAIT = 500;
        private final int DEFAULT_NEW_JOB_WAIT = 100;
        private boolean newJob;
        private long waitTime = 500L;
        private final Object mutex = new Object();

        ScheduleTime() {
        }

        long getWaitTime() {
            return this.waitTime;
        }

        void setWaitTime(long waitTime) {
            if (!this.newJob) {
                this.waitTime = waitTime > 0L ? waitTime : 500L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void pause() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.mutex.wait(this.waitTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        void newJob() {
            this.newJob = true;
            this.waitTime = 100L;
            this.wakeup();
        }

        void clearNewJob() {
            this.newJob = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void wakeup() {
            Object object = this.mutex;
            synchronized (object) {
                this.mutex.notifyAll();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ValueMarshaller
    extends VariableMarshaller<List<JobLocation>> {
        static ValueMarshaller INSTANCE = new ValueMarshaller();

        ValueMarshaller() {
        }

        public List<JobLocation> readPayload(DataInput dataIn) throws IOException {
            ArrayList<JobLocation> result = new ArrayList<JobLocation>();
            int size = dataIn.readInt();
            for (int i = 0; i < size; ++i) {
                JobLocation jobLocation = new JobLocation();
                jobLocation.readExternal(dataIn);
                result.add(jobLocation);
            }
            return result;
        }

        public void writePayload(List<JobLocation> value, DataOutput dataOut) throws IOException {
            dataOut.writeInt(value.size());
            for (JobLocation jobLocation : value) {
                jobLocation.writeExternal(dataOut);
            }
        }
    }
}

