/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.scheduler;

import com.bes.hsdb.util.ByteSequence;
import com.bes.mq.besmp.BESMPFormat;
import com.bes.mq.broker.Broker;
import com.bes.mq.broker.BrokerFilter;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.ProducerBrokerExchange;
import com.bes.mq.broker.scheduler.Job;
import com.bes.mq.broker.scheduler.JobListener;
import com.bes.mq.broker.scheduler.JobScheduler;
import com.bes.mq.broker.scheduler.JobSchedulerFacade;
import com.bes.mq.broker.scheduler.JobSchedulerStore;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageId;
import com.bes.mq.command.ProducerId;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.security.SecurityContext;
import com.bes.mq.state.ProducerState;
import com.bes.mq.util.IdGenerator;
import com.bes.mq.util.LongSequenceGenerator;
import com.bes.mq.util.TypeConversionSupport;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;

public class SchedulerBroker
extends BrokerFilter
implements JobListener {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerBroker.class);
    private static final IdGenerator ID_GENERATOR = new IdGenerator();
    private final LongSequenceGenerator messageIdGenerator = new LongSequenceGenerator();
    private final AtomicBoolean started = new AtomicBoolean();
    private final ProtocolFormat protocolFormat = new BESMPFormat();
    private final ConnectionContext context = new ConnectionContext();
    private final ProducerId producerId = new ProducerId();
    private File directory;
    private JobSchedulerStore store;
    private JobScheduler scheduler;

    public SchedulerBroker(Broker next, File directory) throws Exception {
        super(next);
        this.directory = directory;
        this.producerId.setConnectionId(ID_GENERATOR.generateId());
        this.context.setSecurityContext(SecurityContext.BROKER_SECURITY_CONTEXT);
        this.context.setBroker(next);
        LOG.info("Scheduler using directory: " + directory);
    }

    public synchronized JobScheduler getJobScheduler() throws Exception {
        return new JobSchedulerFacade(this);
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public void start() throws Exception {
        this.started.set(true);
        this.getInternalScheduler();
        super.start();
    }

    public void stop() throws Exception {
        if (this.started.compareAndSet(true, false)) {
            if (this.store != null) {
                this.store.stop();
            }
            if (this.scheduler != null) {
                this.scheduler.removeListener(this);
                this.scheduler = null;
            }
        }
        super.stop();
    }

    public void send(ProducerBrokerExchange producerExchange, Message messageSend) throws Exception {
        long delay = 0L;
        long period = 0L;
        int repeat = 0;
        String cronEntry = "";
        String jobId = (String)messageSend.getProperty("scheduledJobId");
        Object cronValue = messageSend.getProperty("BMQ_SCHEDULED_CRON");
        Object periodValue = messageSend.getProperty("BMQ_SCHEDULED_PERIOD");
        Object delayValue = messageSend.getProperty("BMQ_SCHEDULED_DELAY");
        String physicalName = messageSend.getDestination().getPhysicalName();
        boolean schedularManage = physicalName.regionMatches(true, 0, "BESMQ.Scheduler.Management", 0, "BESMQ.Scheduler.Management".length());
        if (schedularManage) {
            JobScheduler scheduler = this.getInternalScheduler();
            BESMQDestination replyTo = messageSend.getReplyTo();
            String action = (String)messageSend.getProperty("BMQ_SCHEDULER_ACTION");
            if (action != null) {
                long finish;
                long start;
                Object startTime = messageSend.getProperty("ACTION_START_TIME");
                Object endTime = messageSend.getProperty("ACTION_END_TIME");
                if (replyTo != null && action.equals("BROWSE")) {
                    if (startTime != null && endTime != null) {
                        start = (Long)TypeConversionSupport.convert(startTime, Long.class);
                        finish = (Long)TypeConversionSupport.convert(endTime, Long.class);
                        for (Job job : scheduler.getAllJobs(start, finish)) {
                            this.sendScheduledJob(producerExchange.getConnectionContext(), job, replyTo);
                        }
                    } else {
                        for (Job job : scheduler.getAllJobs()) {
                            this.sendScheduledJob(producerExchange.getConnectionContext(), job, replyTo);
                        }
                    }
                }
                if (jobId != null && action.equals("REMOVE")) {
                    scheduler.remove(jobId);
                } else if (action.equals("REMOVEALL")) {
                    if (startTime != null && endTime != null) {
                        start = (Long)TypeConversionSupport.convert(startTime, Long.class);
                        finish = (Long)TypeConversionSupport.convert(endTime, Long.class);
                        scheduler.removeAllJobs(start, finish);
                    } else {
                        scheduler.removeAllJobs();
                    }
                }
            }
        } else if ((cronValue != null || periodValue != null || delayValue != null) && jobId == null) {
            Object repeatValue;
            Message msg = messageSend.copy();
            msg.setTransactionId(null);
            com.bes.mq.util.ByteSequence packet = this.protocolFormat.marshal(msg);
            if (cronValue != null) {
                cronEntry = cronValue.toString();
            }
            if (periodValue != null) {
                period = (Long)TypeConversionSupport.convert(periodValue, Long.class);
            }
            if (delayValue != null) {
                delay = (Long)TypeConversionSupport.convert(delayValue, Long.class);
            }
            if ((repeatValue = msg.getProperty("BMQ_SCHEDULED_REPEAT")) != null) {
                repeat = (Integer)TypeConversionSupport.convert(repeatValue, Integer.class);
            }
            this.getInternalScheduler().schedule(msg.getMessageId().toString(), new ByteSequence(packet.data, packet.offset, packet.length), cronEntry, delay, period, repeat);
        } else {
            super.send(producerExchange, messageSend);
        }
    }

    public void scheduledJob(String id, ByteSequence job) {
        com.bes.mq.util.ByteSequence packet = new com.bes.mq.util.ByteSequence(job.getData(), job.getOffset(), job.getLength());
        try {
            Message messageSend = (Message)this.protocolFormat.unmarshal(packet);
            messageSend.setOriginalTransactionId(null);
            Object repeatValue = messageSend.getProperty("BMQ_SCHEDULED_REPEAT");
            Object cronValue = messageSend.getProperty("BMQ_SCHEDULED_CRON");
            String cronStr = cronValue != null ? cronValue.toString() : null;
            int repeat = 0;
            if (repeatValue != null) {
                repeat = (Integer)TypeConversionSupport.convert(repeatValue, Integer.class);
            }
            if (repeat != 0 || cronStr != null && cronStr.length() > 0) {
                messageSend.setMessageId(new MessageId(this.producerId, this.messageIdGenerator.getNextSequenceId()));
            }
            messageSend.setProperty("scheduledJobId", id);
            messageSend.removeProperty("BMQ_SCHEDULED_PERIOD");
            messageSend.removeProperty("BMQ_SCHEDULED_DELAY");
            messageSend.removeProperty("BMQ_SCHEDULED_REPEAT");
            messageSend.removeProperty("BMQ_SCHEDULED_CRON");
            if (messageSend.getTimestamp() > 0L && messageSend.getExpiration() > 0L) {
                long expiration;
                long oldExpiration = messageSend.getExpiration();
                long newTimeStamp = System.currentTimeMillis();
                long timeToLive = 0L;
                long oldTimestamp = messageSend.getTimestamp();
                if (oldExpiration > 0L) {
                    timeToLive = oldExpiration - oldTimestamp;
                }
                if ((expiration = timeToLive + newTimeStamp) > oldExpiration) {
                    if (timeToLive > 0L && expiration > 0L) {
                        messageSend.setExpiration(expiration);
                    }
                    messageSend.setTimestamp(newTimeStamp);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Set message " + messageSend.getMessageId() + " timestamp from " + oldTimestamp + " to " + newTimeStamp);
                    }
                }
            }
            ProducerBrokerExchange producerExchange = new ProducerBrokerExchange();
            producerExchange.setConnectionContext(this.context);
            producerExchange.setMutable(true);
            producerExchange.setProducerState(new ProducerState(new ProducerInfo()));
            super.send(producerExchange, messageSend);
        }
        catch (Exception e) {
            LOG.error("Failed to send scheduled message " + id, e);
        }
    }

    protected synchronized JobScheduler getInternalScheduler() throws Exception {
        if (this.started.get()) {
            if (this.scheduler == null) {
                this.scheduler = this.getStore().getJobScheduler("JMS");
                this.scheduler.addListener(this);
            }
            return this.scheduler;
        }
        return null;
    }

    private JobSchedulerStore getStore() throws Exception {
        if (this.started.get()) {
            if (this.store == null) {
                this.store = new JobSchedulerStore();
                this.store.setDirectory(this.directory);
                this.store.start();
            }
            return this.store;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendScheduledJob(ConnectionContext context, Job job, BESMQDestination replyTo) throws Exception {
        com.bes.mq.util.ByteSequence packet = new com.bes.mq.util.ByteSequence(job.getPayload());
        try {
            Message msg = (Message)this.protocolFormat.unmarshal(packet);
            msg.setOriginalTransactionId(null);
            msg.setPersistent(false);
            msg.setType("Notification");
            msg.setMessageId(new MessageId(this.producerId, this.messageIdGenerator.getNextSequenceId()));
            msg.setDestination(replyTo);
            msg.setResponseRequired(false);
            msg.setProducerId(this.producerId);
            msg.setProperty("scheduledJobId", job.getJobId());
            boolean originalFlowControl = context.isProducerFlowControl();
            ProducerBrokerExchange producerExchange = new ProducerBrokerExchange();
            producerExchange.setConnectionContext(context);
            producerExchange.setMutable(true);
            producerExchange.setProducerState(new ProducerState(new ProducerInfo()));
            try {
                context.setProducerFlowControl(false);
                this.next.send(producerExchange, msg);
            }
            finally {
                context.setProducerFlowControl(originalFlowControl);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to send scheduled message " + job.getJobId(), e);
        }
    }
}

