/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.util;

import com.bes.mq.BESMQConnectionFactory;
import com.bes.mq.Service;
import com.bes.mq.broker.util.CommandMessageListener;
import com.bes.mq.notification.NotificationSupport;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;

public class CommandAgent
implements Service,
ExceptionListener {
    private static final Logger LOG = LoggerFactory.getLogger(CommandAgent.class);
    private String brokerUrl = "vm://localhost";
    private String username;
    private String password;
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private Destination commandDestination;
    private CommandMessageListener listener;
    private Session session;
    private MessageConsumer consumer;
    private String name;

    @PostConstruct
    public void start() throws Exception {
        this.session = this.getConnection().createSession(false, 1);
        this.listener = new CommandMessageListener(this.session);
        Destination destination = this.getCommandDestination();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Agent subscribing to control destination: " + destination);
        }
        this.consumer = this.session.createConsumer(destination);
        this.consumer.setMessageListener(this.listener);
    }

    @PreDestroy
    public void stop() throws Exception {
        if (this.consumer != null) {
            try {
                this.consumer.close();
                this.consumer = null;
            }
            catch (JMSException ignored) {
                // empty catch block
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
                this.session = null;
            }
            catch (JMSException ignored) {
                // empty catch block
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    public void setBrokerUrl(String brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = new BESMQConnectionFactory(this.brokerUrl);
        }
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Connection getConnection() throws JMSException {
        if (this.connection == null) {
            this.connection = this.createConnection();
            this.connection.setExceptionListener(this);
            this.connection.start();
        }
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Destination getCommandDestination() {
        if (this.commandDestination == null) {
            this.commandDestination = this.createCommandDestination();
        }
        return this.commandDestination;
    }

    public void setCommandDestination(Destination commandDestination) {
        this.commandDestination = commandDestination;
    }

    protected Connection createConnection() throws JMSException {
        return this.getConnectionFactory().createConnection(this.username, this.password);
    }

    protected Destination createCommandDestination() {
        return NotificationSupport.getAgentDestination();
    }

    public void onException(JMSException exception) {
        try {
            this.stop();
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

