/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.util;

import com.bes.mq.broker.BrokerPluginSupport;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.ConsumerBrokerExchange;
import com.bes.mq.broker.ProducerBrokerExchange;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.ConsumerControl;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.DestinationInfo;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessagePull;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.command.Response;
import com.bes.mq.filter.DestinationPath;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class DestinationPathSeparatorBroker
extends BrokerPluginSupport {
    String pathSeparator = "/";

    protected BESMQDestination convertDestination(BESMQDestination destination) {
        if (destination != null && destination.getPhysicalName().contains(this.pathSeparator)) {
            ArrayList<String> l = new ArrayList<String>();
            StringTokenizer iter = new StringTokenizer(destination.getPhysicalName(), this.pathSeparator);
            while (iter.hasMoreTokens()) {
                String name = iter.nextToken().trim();
                if (name.length() == 0) continue;
                l.add(name);
            }
            String newName = DestinationPath.toString(l.toArray(new String[l.size()]));
            return BESMQDestination.createDestination(newName, destination.getDestinationType());
        }
        return destination;
    }

    public void acknowledge(ConsumerBrokerExchange consumerExchange, MessageAck ack) throws Exception {
        ack.setDestination(this.convertDestination(ack.getDestination()));
        super.acknowledge(consumerExchange, ack);
    }

    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        info.setDestination(this.convertDestination(info.getDestination()));
        return super.addConsumer(context, info);
    }

    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        info.setDestination(this.convertDestination(info.getDestination()));
        super.addProducer(context, info);
    }

    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        info.setDestination(this.convertDestination(info.getDestination()));
        super.removeConsumer(context, info);
    }

    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        info.setDestination(this.convertDestination(info.getDestination()));
        super.removeProducer(context, info);
    }

    public void send(ProducerBrokerExchange producerExchange, Message messageSend) throws Exception {
        messageSend.setDestination(this.convertDestination(messageSend.getDestination()));
        super.send(producerExchange, messageSend);
    }

    public Destination addDestination(ConnectionContext context, BESMQDestination destination, boolean createIfTemporary) throws Exception {
        return super.addDestination(context, this.convertDestination(destination), createIfTemporary);
    }

    public void removeDestination(ConnectionContext context, BESMQDestination destination, long timeout) throws Exception {
        super.removeDestination(context, this.convertDestination(destination), timeout);
    }

    public void addDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        info.setDestination(this.convertDestination(info.getDestination()));
        super.addDestinationInfo(context, info);
    }

    public void removeDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        info.setDestination(this.convertDestination(info.getDestination()));
        super.removeDestinationInfo(context, info);
    }

    public void processConsumerControl(ConsumerBrokerExchange consumerExchange, ConsumerControl control) {
        control.setDestination(this.convertDestination(control.getDestination()));
        super.processConsumerControl(consumerExchange, control);
    }

    public Response messagePull(ConnectionContext context, MessagePull pull) throws Exception {
        pull.setDestination(this.convertDestination(pull.getDestination()));
        return super.messagePull(context, pull);
    }

    public void setPathSeparator(String pathSeparator) {
        this.pathSeparator = pathSeparator;
    }
}

