/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.util;

import com.bes.mq.RedeliveryPolicy;
import com.bes.mq.broker.Broker;
import com.bes.mq.broker.BrokerPluginSupport;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.ProducerBrokerExchange;
import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.broker.region.policy.RedeliveryPolicyMap;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQQueue;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.Message;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.filter.AnyDestination;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.state.ProducerState;
import java.io.IOException;

public class RedeliveryPlugin
extends BrokerPluginSupport {
    private static final Logger LOG = LoggerFactory.getLogger(RedeliveryPlugin.class);
    public static final String REDELIVERY_DELAY = "redeliveryDelay";
    RedeliveryPolicyMap redeliveryPolicyMap = new RedeliveryPolicyMap();
    boolean sendToDlqIfMaxRetriesExceeded = true;
    private boolean fallbackToDeadLetter = true;

    public Broker installPlugin(Broker broker) throws Exception {
        if (!broker.getBrokerService().isSchedulerSupport()) {
            throw new IllegalStateException("RedeliveryPlugin requires schedulerSupport=true on the broker");
        }
        this.validatePolicyDelay(1000L);
        return super.installPlugin(broker);
    }

    private void validatePolicyDelay(long limit) {
        AnyDestination matchAll = new AnyDestination(new BESMQDestination[]{new BESMQQueue(">"), new BESMQTopic(">")});
        for (Object entry : this.redeliveryPolicyMap.get(matchAll)) {
            RedeliveryPolicy redeliveryPolicy = (RedeliveryPolicy)entry;
            this.validateLimit(limit, redeliveryPolicy);
        }
        RedeliveryPolicy defaultEntry = this.redeliveryPolicyMap.getDefaultEntry();
        if (defaultEntry != null) {
            this.validateLimit(limit, defaultEntry);
        }
    }

    private void validateLimit(long limit, RedeliveryPolicy redeliveryPolicy) {
        if (redeliveryPolicy.getInitialRedeliveryDelay() < limit) {
            throw new IllegalStateException("RedeliveryPolicy initialRedeliveryDelay must exceed: " + limit + ". " + redeliveryPolicy);
        }
        if (redeliveryPolicy.getRedeliveryDelay() < limit) {
            throw new IllegalStateException("RedeliveryPolicy redeliveryDelay must exceed: " + limit + ". " + redeliveryPolicy);
        }
    }

    public RedeliveryPolicyMap getRedeliveryPolicyMap() {
        return this.redeliveryPolicyMap;
    }

    public void setRedeliveryPolicyMap(RedeliveryPolicyMap redeliveryPolicyMap) {
        this.redeliveryPolicyMap = redeliveryPolicyMap;
    }

    public boolean isSendToDlqIfMaxRetriesExceeded() {
        return this.sendToDlqIfMaxRetriesExceeded;
    }

    public void setSendToDlqIfMaxRetriesExceeded(boolean sendToDlqIfMaxRetriesExceeded) {
        this.sendToDlqIfMaxRetriesExceeded = sendToDlqIfMaxRetriesExceeded;
    }

    public boolean isFallbackToDeadLetter() {
        return this.fallbackToDeadLetter;
    }

    public void setFallbackToDeadLetter(boolean fallbackToDeadLetter) {
        this.fallbackToDeadLetter = fallbackToDeadLetter;
    }

    public boolean sendToDeadLetterQueue(ConnectionContext context, MessageReference messageReference, Subscription subscription, Throwable poisonCause) {
        if (((Broker)this.next.get()).isExpired(messageReference)) {
            return super.sendToDeadLetterQueue(context, messageReference, subscription, poisonCause);
        }
        try {
            RedeliveryPolicy redeliveryPolicy = this.redeliveryPolicyMap.getEntryFor(messageReference.getRegionDestination().getBESMQDestination());
            if (redeliveryPolicy != null) {
                int redeliveryCount = messageReference.getRedeliveryCounter();
                if (redeliveryCount < redeliveryPolicy.getMaximumRedeliveries()) {
                    long delay = redeliveryCount == 0 ? redeliveryPolicy.getInitialRedeliveryDelay() : redeliveryPolicy.getNextRedeliveryDelay(this.getExistingDelay(messageReference));
                    this.scheduleRedelivery(context, messageReference, delay, ++redeliveryCount);
                } else {
                    if (this.isSendToDlqIfMaxRetriesExceeded()) {
                        return super.sendToDeadLetterQueue(context, messageReference, subscription, poisonCause);
                    }
                    LOG.debug("Discarding message that exceeds max redelivery count, " + messageReference.getMessageId());
                }
            } else {
                if (this.isFallbackToDeadLetter()) {
                    return super.sendToDeadLetterQueue(context, messageReference, subscription, poisonCause);
                }
                LOG.debug("Ignoring dlq request for:" + messageReference.getMessageId() + ", RedeliveryPolicy not found (and no fallback) for: " + messageReference.getRegionDestination().getBESMQDestination());
            }
            return false;
        }
        catch (Exception exception) {
            RuntimeException toThrow = new RuntimeException("Failed to schedule redelivery for: " + messageReference.getMessageId(), exception);
            LOG.error(toThrow.toString(), exception);
            throw toThrow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRedelivery(ConnectionContext context, MessageReference messageReference, long delay, int redeliveryCount) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Redelivery #" + redeliveryCount + " of: " + messageReference.getMessageId() + " with delay: " + delay + ", dest: " + messageReference.getRegionDestination().getBESMQDestination());
        }
        Message old = messageReference.getMessage();
        Message message = old.copy();
        message.setTransactionId(null);
        message.setMemoryUsage(null);
        message.setMarshalledProperties(null);
        message.removeProperty("scheduledJobId");
        message.setProperty(REDELIVERY_DELAY, delay);
        message.setProperty("BMQ_SCHEDULED_DELAY", delay);
        message.setRedeliveryCounter(redeliveryCount);
        boolean originalFlowControl = context.isProducerFlowControl();
        try {
            context.setProducerFlowControl(false);
            ProducerInfo info = new ProducerInfo();
            ProducerState state = new ProducerState(info);
            ProducerBrokerExchange producerExchange = new ProducerBrokerExchange();
            producerExchange.setProducerState(state);
            producerExchange.setMutable(true);
            producerExchange.setConnectionContext(context);
            context.getBroker().send(producerExchange, message);
        }
        finally {
            context.setProducerFlowControl(originalFlowControl);
        }
    }

    private int getExistingDelay(MessageReference messageReference) throws IOException {
        Object val = messageReference.getMessage().getProperty(REDELIVERY_DELAY);
        if (val instanceof Long) {
            return ((Long)val).intValue();
        }
        return 0;
    }
}

