/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.util;

import com.bes.mq.broker.BrokerPluginSupport;
import com.bes.mq.broker.ProducerBrokerExchange;
import com.bes.mq.broker.region.policy.DeadLetterStrategy;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.command.Message;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;

public class TimeStampingBrokerPlugin
extends BrokerPluginSupport {
    private static final Logger LOG = LoggerFactory.getLogger(TimeStampingBrokerPlugin.class);
    long zeroExpirationOverride = 0L;
    long ttlCeiling = 0L;
    boolean futureOnly = false;
    boolean processNetworkMessages = false;

    public void setZeroExpirationOverride(long ttl) {
        this.zeroExpirationOverride = ttl;
    }

    public void setTtlCeiling(long ttlCeiling) {
        this.ttlCeiling = ttlCeiling;
    }

    public void setFutureOnly(boolean futureOnly) {
        this.futureOnly = futureOnly;
    }

    public void setProcessNetworkMessages(Boolean processNetworkMessages) {
        this.processNetworkMessages = processNetworkMessages;
    }

    public void send(ProducerBrokerExchange producerExchange, Message message) throws Exception {
        if (message.getTimestamp() > 0L && !this.isDestinationDLQ(message) && (this.processNetworkMessages || message.getBrokerPath() == null || message.getBrokerPath().length == 0)) {
            long oldExpiration = message.getExpiration();
            long newTimeStamp = System.currentTimeMillis();
            long timeToLive = this.zeroExpirationOverride;
            long oldTimestamp = message.getTimestamp();
            if (oldExpiration > 0L) {
                timeToLive = oldExpiration - oldTimestamp;
            }
            if (timeToLive > 0L && this.ttlCeiling > 0L && timeToLive > this.ttlCeiling) {
                timeToLive = this.ttlCeiling;
            }
            long expiration = timeToLive + newTimeStamp;
            if (!this.futureOnly || expiration > oldExpiration) {
                if (timeToLive > 0L && expiration > 0L) {
                    message.setExpiration(expiration);
                }
                message.setTimestamp(newTimeStamp);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set message " + message.getMessageId() + " timestamp from " + oldTimestamp + " to " + newTimeStamp);
                }
            }
        }
        super.send(producerExchange, message);
    }

    private boolean isDestinationDLQ(Message message) {
        DeadLetterStrategy deadLetterStrategy;
        if (message != null && message.getRegionDestination() != null && (deadLetterStrategy = message.getRegionDestination().getDeadLetterStrategy()) != null) {
            BESMQMessage tmp = new BESMQMessage();
            tmp.setDestination(message.getOriginalDestination());
            tmp.setRegionDestination(message.getRegionDestination());
            BESMQDestination deadLetterDestination = deadLetterStrategy.getDeadLetterQueueFor(tmp, null);
            if (deadLetterDestination.equals(message.getDestination())) {
                return true;
            }
        }
        return false;
    }
}

