/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.util;

import com.bes.mq.broker.BrokerPluginSupport;
import com.bes.mq.command.MessageDispatch;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import java.io.IOException;

public class TraceBrokerPathPlugin
extends BrokerPluginSupport {
    private String stampProperty = "BrokerPath";
    private static final Logger LOG = LoggerFactory.getLogger(TraceBrokerPathPlugin.class);

    public String getStampProperty() {
        return this.stampProperty;
    }

    public void setStampProperty(String stampProperty) {
        if (stampProperty != null && !stampProperty.isEmpty()) {
            this.stampProperty = stampProperty;
        }
    }

    public void preProcessDispatch(MessageDispatch messageDispatch) {
        try {
            if (messageDispatch != null && messageDispatch.getMessage() != null) {
                String brokerStamp = (String)messageDispatch.getMessage().getProperty(this.getStampProperty());
                brokerStamp = brokerStamp == null ? this.getBrokerName() : brokerStamp + "," + this.getBrokerName();
                messageDispatch.getMessage().setProperty(this.getStampProperty(), brokerStamp);
                messageDispatch.getMessage().setMarshalledProperties(null);
            }
        }
        catch (IOException ioe) {
            LOG.warn("Setting broker property failed " + ioe, ioe);
        }
        super.preProcessDispatch(messageDispatch);
    }
}

