/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.util;

import com.bes.mq.besmp.BESMPFormatFactory;
import com.bes.mq.broker.BrokerPluginSupport;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.ConsumerBrokerExchange;
import com.bes.mq.broker.ProducerBrokerExchange;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BrokerId;
import com.bes.mq.command.ConnectionInfo;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.DataStructure;
import com.bes.mq.command.DestinationInfo;
import com.bes.mq.command.JournalTrace;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageDispatch;
import com.bes.mq.command.MessageDispatchNotification;
import com.bes.mq.command.MessagePull;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.command.RemoveSubscriptionInfo;
import com.bes.mq.command.Response;
import com.bes.mq.command.SessionInfo;
import com.bes.mq.command.TransactionId;
import com.bes.mq.command.TransactionInfo;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.protocolformat.ProtocolFormatFactory;
import com.bes.mq.util.ByteArrayOutputStream;
import com.bes.mq.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;

public class UDPTraceBrokerPlugin
extends BrokerPluginSupport {
    private static final Logger LOG = LoggerFactory.getLogger(UDPTraceBrokerPlugin.class);
    protected ProtocolFormat protocolFormat;
    protected ProtocolFormatFactory protocolFormatFactory;
    protected int maxTraceDatagramSize = 4096;
    protected URI destination;
    protected DatagramSocket socket;
    protected BrokerId brokerId;
    protected SocketAddress address;
    protected boolean broadcast;

    public UDPTraceBrokerPlugin() {
        try {
            this.destination = new URI("udp://127.0.0.1:3200");
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public void start() throws Exception {
        super.start();
        if (this.getProtocolFormat() == null) {
            throw new IllegalArgumentException("ProtocolFormat must be specified.");
        }
        if (this.address == null) {
            this.address = this.createSocketAddress(this.destination);
        }
        this.socket = this.createSocket();
        this.brokerId = super.getBrokerId();
        this.trace(new JournalTrace("START"));
    }

    protected DatagramSocket createSocket() throws IOException {
        DatagramSocket s = new DatagramSocket();
        s.setSendBufferSize(this.maxTraceDatagramSize);
        s.setBroadcast(this.broadcast);
        return s;
    }

    public void stop() throws Exception {
        this.trace(new JournalTrace("STOP"));
        this.socket.close();
        super.stop();
    }

    private void trace(DataStructure command) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.maxTraceDatagramSize);
            DataOutputStream out = new DataOutputStream(baos);
            this.protocolFormat.marshal(this.brokerId, out);
            this.protocolFormat.marshal(command, out);
            out.close();
            ByteSequence sequence = baos.toByteSequence();
            DatagramPacket datagram = new DatagramPacket(sequence.getData(), sequence.getOffset(), sequence.getLength(), this.address);
            this.socket.send(datagram);
        }
        catch (Throwable e) {
            LOG.debug("Failed to trace: " + command, e);
        }
    }

    public void send(ProducerBrokerExchange producerExchange, Message messageSend) throws Exception {
        this.trace(messageSend);
        super.send(producerExchange, messageSend);
    }

    public void acknowledge(ConsumerBrokerExchange consumerExchange, MessageAck ack) throws Exception {
        this.trace(ack);
        super.acknowledge(consumerExchange, ack);
    }

    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        this.trace(info);
        super.addConnection(context, info);
    }

    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        this.trace(info);
        return super.addConsumer(context, info);
    }

    public void addDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        this.trace(info);
        super.addDestinationInfo(context, info);
    }

    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        this.trace(info);
        super.addProducer(context, info);
    }

    public void addSession(ConnectionContext context, SessionInfo info) throws Exception {
        this.trace(info);
        super.addSession(context, info);
    }

    public void beginTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        this.trace(new TransactionInfo(context.getConnectionId(), xid, 0));
        super.beginTransaction(context, xid);
    }

    public void commitTransaction(ConnectionContext context, TransactionId xid, boolean onePhase) throws Exception {
        this.trace(new TransactionInfo(context.getConnectionId(), xid, onePhase ? (byte)2 : 3));
        super.commitTransaction(context, xid, onePhase);
    }

    public void forgetTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        this.trace(new TransactionInfo(context.getConnectionId(), xid, 6));
        super.forgetTransaction(context, xid);
    }

    public Response messagePull(ConnectionContext context, MessagePull pull) throws Exception {
        this.trace(pull);
        return super.messagePull(context, pull);
    }

    public int prepareTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        this.trace(new TransactionInfo(context.getConnectionId(), xid, 1));
        return super.prepareTransaction(context, xid);
    }

    public void postProcessDispatch(MessageDispatch messageDispatch) {
        this.trace(messageDispatch);
        super.postProcessDispatch(messageDispatch);
    }

    public void processDispatchNotification(MessageDispatchNotification messageDispatchNotification) throws Exception {
        this.trace(messageDispatchNotification);
        super.processDispatchNotification(messageDispatchNotification);
    }

    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        this.trace(info.createRemoveCommand());
        super.removeConnection(context, info, error);
    }

    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        this.trace(info.createRemoveCommand());
        super.removeConsumer(context, info);
    }

    public void removeDestination(ConnectionContext context, BESMQDestination destination, long timeout) throws Exception {
        super.removeDestination(context, destination, timeout);
    }

    public void removeDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        this.trace(info);
        super.removeDestinationInfo(context, info);
    }

    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        this.trace(info.createRemoveCommand());
        super.removeProducer(context, info);
    }

    public void removeSession(ConnectionContext context, SessionInfo info) throws Exception {
        this.trace(info.createRemoveCommand());
        super.removeSession(context, info);
    }

    public void removeSubscription(ConnectionContext context, RemoveSubscriptionInfo info) throws Exception {
        this.trace(info);
        super.removeSubscription(context, info);
    }

    public void rollbackTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        this.trace(new TransactionInfo(context.getConnectionId(), xid, 4));
        super.rollbackTransaction(context, xid);
    }

    public ProtocolFormat getProtocolFormat() {
        if (this.protocolFormat == null) {
            this.protocolFormat = this.createProtocolFormat();
        }
        return this.protocolFormat;
    }

    protected ProtocolFormat createProtocolFormat() {
        return this.getProtocolFormatFactory().createProtocolFormat();
    }

    public void setProtocolFormat(ProtocolFormat protocolFormat) {
        this.protocolFormat = protocolFormat;
    }

    public ProtocolFormatFactory getProtocolFormatFactory() {
        if (this.protocolFormatFactory == null) {
            this.protocolFormatFactory = this.createProtocolFormatFactory();
        }
        return this.protocolFormatFactory;
    }

    protected BESMPFormatFactory createProtocolFormatFactory() {
        BESMPFormatFactory wf = new BESMPFormatFactory();
        wf.setCacheEnabled(false);
        wf.setVersion(1);
        wf.setTightEncodingEnabled(false);
        wf.setSizePrefixDisabled(true);
        return wf;
    }

    public void setProtocolFormatFactory(ProtocolFormatFactory protocolFormatFactory) {
        this.protocolFormatFactory = protocolFormatFactory;
    }

    protected SocketAddress createSocketAddress(URI location) throws UnknownHostException {
        InetAddress a = InetAddress.getByName(location.getHost());
        int port = location.getPort();
        return new InetSocketAddress(a, port);
    }

    public URI getDestination() {
        return this.destination;
    }

    public void setDestination(URI destination) {
        this.destination = destination;
    }

    public int getMaxTraceDatagramSize() {
        return this.maxTraceDatagramSize;
    }

    public void setMaxTraceDatagramSize(int maxTraceDatagramSize) {
        this.maxTraceDatagramSize = maxTraceDatagramSize;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public SocketAddress getAddress() {
        return this.address;
    }

    public void setAddress(SocketAddress address) {
        this.address = address;
    }
}

