/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.view;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.view.DotFileInterceptorSupport;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.filter.DestinationMap;
import com.bes.mq.filter.DestinationMapNode;
import com.bes.mq.filter.DestinationNode;
import java.io.PrintWriter;
import java.util.Collection;

public class DestinationDotFileInterceptor
extends DotFileInterceptorSupport {
    protected static final String ID_SEPARATOR = "_";

    public DestinationDotFileInterceptor(Broker next, String file) {
        super(next, file);
    }

    public Destination addDestination(ConnectionContext context, BESMQDestination destination, boolean create) throws Exception {
        Destination answer = super.addDestination(context, destination, create);
        this.generateFile();
        return answer;
    }

    public void removeDestination(ConnectionContext context, BESMQDestination destination, long timeout) throws Exception {
        super.removeDestination(context, destination, timeout);
        this.generateFile();
    }

    protected void generateFile(PrintWriter writer) throws Exception {
        BESMQDestination[] destinations = this.getDestinations();
        DestinationMap map = new DestinationMap();
        for (int i = 0; i < destinations.length; ++i) {
            BESMQDestination destination = destinations[i];
            map.put(destination, destination);
        }
        writer.println("digraph \"BESMQ Destinations\" {");
        writer.println();
        writer.println("node [style = \"rounded,filled\", fontname=\"Helvetica-Oblique\"];");
        writer.println();
        writer.println("topic_root [fillcolor = deepskyblue, label = \"Topics\" ];");
        writer.println("queue_root [fillcolor = deepskyblue, label = \"Queues\" ];");
        writer.println();
        writer.println("subgraph queues {");
        writer.println("  node [fillcolor=red];     ");
        writer.println("  label = \"Queues\"");
        writer.println();
        this.printNodeLinks(writer, map.getQueueRootNode(), "queue");
        writer.println("}");
        writer.println();
        writer.println("subgraph temp queues {");
        writer.println("  node [fillcolor=red];     ");
        writer.println("  label = \"TempQueues\"");
        writer.println();
        this.printNodeLinks(writer, map.getTempQueueRootNode(), "tempqueue");
        writer.println("}");
        writer.println();
        writer.println("subgraph topics {");
        writer.println("  node [fillcolor=green];     ");
        writer.println("  label = \"Topics\"");
        writer.println();
        this.printNodeLinks(writer, map.getTopicRootNode(), "topic");
        writer.println("}");
        writer.println();
        writer.println("subgraph temp topics {");
        writer.println("  node [fillcolor=green];     ");
        writer.println("  label = \"TempTopics\"");
        writer.println();
        this.printNodeLinks(writer, map.getTempTopicRootNode(), "temptopic");
        writer.println("}");
        writer.println();
        this.printNodes(writer, map.getQueueRootNode(), "queue");
        writer.println();
        this.printNodes(writer, map.getTempQueueRootNode(), "tempqueue");
        writer.println();
        this.printNodes(writer, map.getTopicRootNode(), "topic");
        writer.println();
        this.printNodes(writer, map.getTempTopicRootNode(), "temptopic");
        writer.println();
        writer.println("}");
    }

    protected void printNodes(PrintWriter writer, DestinationMapNode node, String prefix) {
        String path = this.getPath(node);
        writer.print("  ");
        writer.print(prefix);
        writer.print(ID_SEPARATOR);
        writer.print(path);
        String label = path;
        if (prefix.equals("topic")) {
            label = "Topics";
        } else if (prefix.equals("queue")) {
            label = "Queues";
        }
        writer.print("[ label = \"");
        writer.print(label);
        writer.println("\" ];");
        Collection<DestinationNode> children = node.getChildren();
        for (DestinationMapNode destinationMapNode : children) {
            this.printNodes(writer, destinationMapNode, prefix + ID_SEPARATOR + path);
        }
    }

    protected void printNodeLinks(PrintWriter writer, DestinationMapNode node, String prefix) {
        String path = this.getPath(node);
        Collection<DestinationNode> children = node.getChildren();
        for (DestinationMapNode destinationMapNode : children) {
            writer.print("  ");
            writer.print(prefix);
            writer.print(ID_SEPARATOR);
            writer.print(path);
            writer.print(" -> ");
            writer.print(prefix);
            writer.print(ID_SEPARATOR);
            writer.print(path);
            writer.print(ID_SEPARATOR);
            writer.print(this.getPath(destinationMapNode));
            writer.println(";");
            this.printNodeLinks(writer, destinationMapNode, prefix + ID_SEPARATOR + path);
        }
    }

    protected String getPath(DestinationMapNode node) {
        String path = node.getPath();
        if (path.equals("*")) {
            return "root";
        }
        return path;
    }
}

