/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.com.thoughtworks.xstream.converters.basic;

import com.bes.mq.com.thoughtworks.xstream.converters.ConversionException;
import com.bes.mq.com.thoughtworks.xstream.converters.ErrorReporter;
import com.bes.mq.com.thoughtworks.xstream.converters.ErrorWriter;
import com.bes.mq.com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import com.bes.mq.com.thoughtworks.xstream.core.JVM;
import com.bes.mq.com.thoughtworks.xstream.core.util.ThreadSafeSimpleDateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;

public class DateConverter
extends AbstractSingleValueConverter
implements ErrorReporter {
    private static final String[] DEFAULT_ACCEPTABLE_FORMATS;
    private static final String DEFAULT_PATTERN;
    private static final TimeZone UTC;
    private final ThreadSafeSimpleDateFormat defaultFormat;
    private final ThreadSafeSimpleDateFormat[] acceptableFormats;

    public DateConverter() {
        this(false);
    }

    public DateConverter(TimeZone timeZone) {
        this(DEFAULT_PATTERN, DEFAULT_ACCEPTABLE_FORMATS, timeZone);
    }

    public DateConverter(boolean lenient) {
        this(DEFAULT_PATTERN, DEFAULT_ACCEPTABLE_FORMATS, lenient);
    }

    public DateConverter(String defaultFormat, String[] acceptableFormats) {
        this(defaultFormat, acceptableFormats, false);
    }

    public DateConverter(String defaultFormat, String[] acceptableFormats, TimeZone timeZone) {
        this(defaultFormat, acceptableFormats, timeZone, false);
    }

    public DateConverter(String defaultFormat, String[] acceptableFormats, boolean lenient) {
        this(defaultFormat, acceptableFormats, UTC, lenient);
    }

    public DateConverter(String defaultFormat, String[] acceptableFormats, TimeZone timeZone, boolean lenient) {
        this.defaultFormat = new ThreadSafeSimpleDateFormat(defaultFormat, timeZone, 4, 20, lenient);
        this.acceptableFormats = acceptableFormats != null ? new ThreadSafeSimpleDateFormat[acceptableFormats.length] : new ThreadSafeSimpleDateFormat[]{};
        for (int i = 0; i < this.acceptableFormats.length; ++i) {
            this.acceptableFormats[i] = new ThreadSafeSimpleDateFormat(acceptableFormats[i], timeZone, 1, 20, lenient);
        }
    }

    public boolean canConvert(Class type) {
        return type.equals(Date.class);
    }

    public Object fromString(String str) {
        try {
            return this.defaultFormat.parse(str);
        }
        catch (ParseException e) {
            for (int i = 0; i < this.acceptableFormats.length; ++i) {
                try {
                    return this.acceptableFormats[i].parse(str);
                }
                catch (ParseException e2) {
                    continue;
                }
            }
            throw new ConversionException("Cannot parse date " + str);
        }
    }

    public String toString(Object obj) {
        return this.defaultFormat.format((Date)obj);
    }

    public void appendErrors(ErrorWriter errorWriter) {
        errorWriter.add("Default date pattern", this.defaultFormat.toString());
        for (int i = 0; i < this.acceptableFormats.length; ++i) {
            errorWriter.add("Alternative date pattern", this.acceptableFormats[i].toString());
        }
    }

    static {
        UTC = TimeZone.getTimeZone("UTC");
        String defaultPattern = "yyyy-MM-dd HH:mm:ss.S z";
        ArrayList<String> acceptablePatterns = new ArrayList<String>();
        boolean utcSupported = JVM.canParseUTCDateFormat();
        String string = DEFAULT_PATTERN = utcSupported ? "yyyy-MM-dd HH:mm:ss.S z" : "yyyy-MM-dd HH:mm:ss.S 'UTC'";
        if (!utcSupported) {
            acceptablePatterns.add("yyyy-MM-dd HH:mm:ss.S z");
        }
        acceptablePatterns.add("yyyy-MM-dd HH:mm:ss.S a");
        acceptablePatterns.add("yyyy-MM-dd HH:mm:ssz");
        acceptablePatterns.add("yyyy-MM-dd HH:mm:ss z");
        if (!utcSupported) {
            acceptablePatterns.add("yyyy-MM-dd HH:mm:ss 'UTC'");
        }
        acceptablePatterns.add("yyyy-MM-dd HH:mm:ssa");
        DEFAULT_ACCEPTABLE_FORMATS = acceptablePatterns.toArray(new String[acceptablePatterns.size()]);
    }
}

