/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.com.thoughtworks.xstream.converters.collections;

import com.bes.mq.com.thoughtworks.xstream.converters.ConversionException;
import com.bes.mq.com.thoughtworks.xstream.converters.MarshallingContext;
import com.bes.mq.com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.bes.mq.com.thoughtworks.xstream.converters.collections.MapConverter;
import com.bes.mq.com.thoughtworks.xstream.core.JVM;
import com.bes.mq.com.thoughtworks.xstream.core.util.HierarchicalStreams;
import com.bes.mq.com.thoughtworks.xstream.core.util.PresortedMap;
import com.bes.mq.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.bes.mq.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.bes.mq.com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;

public class TreeMapConverter
extends MapConverter {
    private static final Comparator NULL_MARKER = new NullComparator();
    private static final Field comparatorField;

    public TreeMapConverter(Mapper mapper) {
        super(mapper);
    }

    public boolean canConvert(Class type) {
        return type.equals(TreeMap.class);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        SortedMap sortedMap = (SortedMap)source;
        this.marshalComparator(sortedMap.comparator(), writer, context);
        super.marshal(source, writer, context);
    }

    protected void marshalComparator(Comparator comparator, HierarchicalStreamWriter writer, MarshallingContext context) {
        if (comparator != null) {
            writer.startNode("comparator");
            writer.addAttribute(this.mapper().aliasForSystemAttribute("class"), this.mapper().serializedClass(comparator.getClass()));
            context.convertAnother(comparator);
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        TreeMap result = comparatorField != null ? new TreeMap() : null;
        Comparator comparator = this.unmarshalComparator(reader, context, result);
        if (result == null) {
            result = comparator == null ? new TreeMap() : new TreeMap(comparator);
        }
        this.populateTreeMap(reader, context, result, comparator);
        return result;
    }

    protected Comparator unmarshalComparator(HierarchicalStreamReader reader, UnmarshallingContext context, TreeMap result) {
        Comparator comparator;
        if (reader.hasMoreChildren()) {
            reader.moveDown();
            if (reader.getNodeName().equals("comparator")) {
                Class comparatorClass = HierarchicalStreams.readClassType(reader, this.mapper());
                comparator = (Comparator)context.convertAnother(result, comparatorClass);
            } else if (reader.getNodeName().equals("no-comparator")) {
                comparator = null;
            } else {
                return NULL_MARKER;
            }
            reader.moveUp();
        } else {
            comparator = null;
        }
        return comparator;
    }

    protected void populateTreeMap(HierarchicalStreamReader reader, UnmarshallingContext context, TreeMap result, Comparator comparator) {
        boolean inFirstElement;
        boolean bl = inFirstElement = comparator == NULL_MARKER;
        if (inFirstElement) {
            comparator = null;
        }
        PresortedMap sortedMap = new PresortedMap(comparator != null && JVM.hasOptimizedTreeMapPutAll() ? comparator : null);
        if (inFirstElement) {
            this.putCurrentEntryIntoMap(reader, context, result, sortedMap);
            reader.moveUp();
        }
        this.populateMap(reader, context, result, sortedMap);
        try {
            if (JVM.hasOptimizedTreeMapPutAll()) {
                if (comparator != null && comparatorField != null) {
                    comparatorField.set(result, comparator);
                }
                result.putAll(sortedMap);
            } else if (comparatorField != null) {
                comparatorField.set(result, sortedMap.comparator());
                result.putAll(sortedMap);
                comparatorField.set(result, comparator);
            } else {
                result.putAll(sortedMap);
            }
        }
        catch (IllegalAccessException e) {
            throw new ConversionException("Cannot set comparator of TreeMap", e);
        }
    }

    static {
        Field cmpField = null;
        try {
            Field[] fields = TreeMap.class.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i].getType() != Comparator.class) continue;
                cmpField = fields[i];
                cmpField.setAccessible(true);
                break;
            }
            if (cmpField == null) {
                throw new ExceptionInInitializerError("Cannot detect comparator field of TreeMap");
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        comparatorField = cmpField;
    }

    private static final class NullComparator
    extends Mapper.Null
    implements Comparator {
        private NullComparator() {
        }

        public int compare(Object o1, Object o2) {
            Comparable c1 = (Comparable)o1;
            Comparable c2 = (Comparable)o2;
            return c1.compareTo(o2);
        }
    }
}

