/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.com.thoughtworks.xstream.converters.extended;

import com.bes.mq.com.thoughtworks.xstream.converters.Converter;
import com.bes.mq.com.thoughtworks.xstream.converters.MarshallingContext;
import com.bes.mq.com.thoughtworks.xstream.converters.SingleValueConverter;
import com.bes.mq.com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.bes.mq.com.thoughtworks.xstream.converters.basic.ByteConverter;
import com.bes.mq.com.thoughtworks.xstream.core.util.Base64Encoder;
import com.bes.mq.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.bes.mq.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;

public class EncodedByteArrayConverter
implements Converter,
SingleValueConverter {
    private static final Base64Encoder base64 = new Base64Encoder();
    private static final ByteConverter byteConverter = new ByteConverter();

    public boolean canConvert(Class type) {
        return type.isArray() && type.getComponentType().equals(Byte.TYPE);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        writer.setValue(this.toString(source));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String data = reader.getValue();
        if (!reader.hasMoreChildren()) {
            return this.fromString(data);
        }
        return this.unmarshalIndividualByteElements(reader, context);
    }

    private Object unmarshalIndividualByteElements(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<Object> bytes = new ArrayList<Object>();
        boolean firstIteration = true;
        while (firstIteration || reader.hasMoreChildren()) {
            reader.moveDown();
            bytes.add(byteConverter.fromString(reader.getValue()));
            reader.moveUp();
            firstIteration = false;
        }
        byte[] result = new byte[bytes.size()];
        int i = 0;
        for (Byte by : bytes) {
            result[i] = by;
            ++i;
        }
        return result;
    }

    public String toString(Object obj) {
        return base64.encode((byte[])obj);
    }

    public Object fromString(String str) {
        return base64.decode(str);
    }
}

