/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.command;

import com.bes.mq.BlobMessage;
import com.bes.mq.blob.BlobDownloader;
import com.bes.mq.blob.BlobUploader;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.command.Message;
import com.bes.mq.util.JMSExceptionSupport;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jms.JMSException;

public class BESMQBlobMessage
extends BESMQMessage
implements BlobMessage {
    public static final byte DATA_STRUCTURE_TYPE = 40;
    public static final String BINARY_MIME_TYPE = "application/octet-stream";
    private String remoteBlobUrl;
    private String mimeType;
    private String name;
    private boolean deletedByBroker;
    private transient BlobUploader blobUploader;
    private transient BlobDownloader blobDownloader;
    private transient URL url;

    public Message copy() {
        BESMQBlobMessage copy = new BESMQBlobMessage();
        this.copy(copy);
        return copy;
    }

    private void copy(BESMQBlobMessage copy) {
        super.copy(copy);
        copy.setRemoteBlobUrl(this.getRemoteBlobUrl());
        copy.setMimeType(this.getMimeType());
        copy.setDeletedByBroker(this.isDeletedByBroker());
        copy.setBlobUploader(this.getBlobUploader());
        copy.setName(this.getName());
    }

    public byte getDataStructureType() {
        return 40;
    }

    public String getRemoteBlobUrl() {
        return this.remoteBlobUrl;
    }

    public void setRemoteBlobUrl(String remoteBlobUrl) {
        this.remoteBlobUrl = remoteBlobUrl;
        this.url = null;
    }

    public String getMimeType() {
        if (this.mimeType == null) {
            return BINARY_MIME_TYPE;
        }
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isDeletedByBroker() {
        return this.deletedByBroker;
    }

    public void setDeletedByBroker(boolean deletedByBroker) {
        this.deletedByBroker = deletedByBroker;
    }

    public String getJMSXMimeType() {
        return this.getMimeType();
    }

    public InputStream getInputStream() throws IOException, JMSException {
        if (this.blobDownloader == null) {
            return null;
        }
        return this.blobDownloader.getInputStream(this);
    }

    public URL getURL() throws JMSException {
        if (this.url == null && this.remoteBlobUrl != null) {
            try {
                this.url = new URL(this.remoteBlobUrl);
            }
            catch (MalformedURLException e) {
                throw JMSExceptionSupport.create(e);
            }
        }
        return this.url;
    }

    public void setURL(URL url) {
        this.url = url;
        this.remoteBlobUrl = url != null ? url.toExternalForm() : null;
    }

    public BlobUploader getBlobUploader() {
        return this.blobUploader;
    }

    public void setBlobUploader(BlobUploader blobUploader) {
        this.blobUploader = blobUploader;
    }

    public BlobDownloader getBlobDownloader() {
        return this.blobDownloader;
    }

    public void setBlobDownloader(BlobDownloader blobDownloader) {
        this.blobDownloader = blobDownloader;
    }

    public void onSend() throws JMSException {
        super.onSend();
        if (this.blobUploader != null) {
            try {
                URL value = this.blobUploader.upload(this);
                this.setURL(value);
            }
            catch (IOException e) {
                throw JMSExceptionSupport.create(e.toString(), e);
            }
        }
    }

    public void deleteFile() throws IOException, JMSException {
        this.blobDownloader.deleteFile(this);
    }
}

