/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.command;

import com.bes.mq.command.BESMQQueue;
import com.bes.mq.command.BESMQTempQueue;
import com.bes.mq.command.BESMQTempTopic;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.DataStructure;
import com.bes.mq.command.DefaultUnresolvedDestinationTransformer;
import com.bes.mq.command.UnresolvedDestinationTransformer;
import com.bes.mq.jndi.JNDIBaseStorable;
import com.bes.mq.util.IntrospectionSupport;
import com.bes.mq.util.URISupport;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BESMQDestination
extends JNDIBaseStorable
implements DataStructure,
Destination,
Externalizable,
Comparable<Object> {
    public static final String PATH_SEPERATOR = ".";
    public static final char COMPOSITE_SEPERATOR = ',';
    public static final byte QUEUE_TYPE = 1;
    public static final byte TOPIC_TYPE = 2;
    public static final byte TEMP_MASK = 4;
    public static final byte TEMP_TOPIC_TYPE = 6;
    public static final byte TEMP_QUEUE_TYPE = 5;
    public static final String QUEUE_QUALIFIED_PREFIX = "queue://";
    public static final String TOPIC_QUALIFIED_PREFIX = "topic://";
    public static final String TEMP_QUEUE_QUALIFED_PREFIX = "temp-queue://";
    public static final String TEMP_TOPIC_QUALIFED_PREFIX = "temp-topic://";
    public static final String TEMP_DESTINATION_NAME_PREFIX = "ID:";
    private static final long serialVersionUID = -3885260014960795889L;
    protected String physicalName;
    protected String name;
    private String jndiName;
    protected transient BESMQDestination[] compositeDestinations;
    protected transient String[] destinationPaths;
    protected transient boolean isPattern;
    protected transient int hashValue;
    protected Map<String, String> options;
    protected static UnresolvedDestinationTransformer unresolvableDestinationTransformer = new DefaultUnresolvedDestinationTransformer();
    private Pattern phyPattern = Pattern.compile("^[^\\&\\-\\$@#=&&[\\x00-\\xff]][^\\&\\$@#&&[\\x00-\\xff]]*$");

    public BESMQDestination() {
    }

    protected BESMQDestination(String name) {
        this.setPhysicalName(name);
    }

    public BESMQDestination(BESMQDestination[] composites) {
        this.setCompositeDestinations(composites);
    }

    public static BESMQDestination createDestination(String name, byte defaultType) {
        if (name.startsWith(QUEUE_QUALIFIED_PREFIX)) {
            return new BESMQQueue(name.substring(QUEUE_QUALIFIED_PREFIX.length()));
        }
        if (name.startsWith(TOPIC_QUALIFIED_PREFIX)) {
            return new BESMQTopic(name.substring(TOPIC_QUALIFIED_PREFIX.length()));
        }
        if (name.startsWith(TEMP_QUEUE_QUALIFED_PREFIX)) {
            return new BESMQTempQueue(name.substring(TEMP_QUEUE_QUALIFED_PREFIX.length()));
        }
        if (name.startsWith(TEMP_TOPIC_QUALIFED_PREFIX)) {
            return new BESMQTempTopic(name.substring(TEMP_TOPIC_QUALIFED_PREFIX.length()));
        }
        switch (defaultType) {
            case 1: {
                return new BESMQQueue(name);
            }
            case 2: {
                return new BESMQTopic(name);
            }
            case 5: {
                return new BESMQTempQueue(name);
            }
            case 6: {
                return new BESMQTempTopic(name);
            }
        }
        throw new IllegalArgumentException("Invalid default destination type: " + defaultType);
    }

    public static BESMQDestination transform(Destination dest) throws JMSException {
        if (dest == null) {
            return null;
        }
        if (dest instanceof BESMQDestination) {
            return (BESMQDestination)dest;
        }
        if (dest instanceof Queue && dest instanceof Topic) {
            String queueName = ((Queue)dest).getQueueName();
            String topicName = ((Topic)dest).getTopicName();
            if (queueName != null && topicName == null) {
                return new BESMQQueue(queueName);
            }
            if (queueName == null && topicName != null) {
                return new BESMQTopic(topicName);
            }
            return unresolvableDestinationTransformer.transform(dest);
        }
        if (dest instanceof TemporaryQueue) {
            return new BESMQTempQueue(((TemporaryQueue)dest).getQueueName());
        }
        if (dest instanceof TemporaryTopic) {
            return new BESMQTempTopic(((TemporaryTopic)dest).getTopicName());
        }
        if (dest instanceof Queue) {
            return new BESMQQueue(((Queue)dest).getQueueName());
        }
        if (dest instanceof Topic) {
            return new BESMQTopic(((Topic)dest).getTopicName());
        }
        throw new JMSException("Could not transform the destination into a BESMQ destination: " + dest);
    }

    public static int compare(BESMQDestination destination, BESMQDestination destination2) {
        if (destination == destination2) {
            return 0;
        }
        if (destination == null) {
            return -1;
        }
        if (destination2 == null) {
            return 1;
        }
        if (destination.isQueue() == destination2.isQueue()) {
            return destination.getPhysicalName().compareTo(destination2.getPhysicalName());
        }
        return destination.isQueue() ? -1 : 1;
    }

    @Override
    public int compareTo(Object that) {
        if (that instanceof BESMQDestination) {
            return BESMQDestination.compare(this, (BESMQDestination)that);
        }
        if (that == null) {
            return 1;
        }
        return this.getClass().getName().compareTo(that.getClass().getName());
    }

    public boolean isComposite() {
        return this.compositeDestinations != null;
    }

    public BESMQDestination[] getCompositeDestinations() {
        return this.compositeDestinations;
    }

    public void setCompositeDestinations(BESMQDestination[] destinations) {
        this.compositeDestinations = destinations;
        this.destinationPaths = null;
        this.hashValue = 0;
        this.isPattern = false;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < destinations.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            if (this.getDestinationType() == destinations[i].getDestinationType()) {
                sb.append(destinations[i].getPhysicalName());
                continue;
            }
            sb.append(destinations[i].getQualifiedName());
        }
        this.physicalName = sb.toString();
    }

    public String getQualifiedName() {
        if (this.isComposite()) {
            return this.physicalName;
        }
        return this.getQualifiedPrefix() + this.physicalName;
    }

    protected abstract String getQualifiedPrefix();

    public String getPhysicalName() {
        return this.physicalName;
    }

    private void validator(String name) {
        String[] names;
        int index = (name = name.trim()).indexOf(63);
        if (index > -1) {
            name = name.substring(0, index);
        }
        if (name.length() < 1) {
            throw new IllegalArgumentException("Invalid destination name: " + name);
        }
        for (String tempName : names = name.split(String.valueOf(','))) {
            Matcher m = this.phyPattern.matcher(tempName);
            if (!m.matches()) {
                throw new IllegalArgumentException("Invalid destination name: " + name);
            }
            if (tempName.length() <= 1 || tempName.charAt(1) != '=') continue;
            throw new IllegalArgumentException("Invalid destination name: " + name);
        }
    }

    public void setPhysicalName(String physicalName) {
        physicalName = physicalName.trim();
        this.validator(physicalName);
        int len = physicalName.length();
        int p = -1;
        boolean composite = false;
        for (int i = 0; i < len; ++i) {
            char c = physicalName.charAt(i);
            if (c == '?') {
                p = i;
                break;
            }
            if (c == ',') {
                this.isPattern = false;
                composite = true;
                continue;
            }
            if (composite || c != '*' && c != '>') continue;
            this.isPattern = true;
        }
        if (p >= 0) {
            String optstring = physicalName.substring(p + 1);
            physicalName = physicalName.substring(0, p);
            try {
                this.options = URISupport.parseQuery(optstring);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid destination name: " + physicalName + ", it's options are not encoded properly: " + e);
            }
        }
        this.physicalName = physicalName;
        this.destinationPaths = null;
        this.hashValue = 0;
        if (composite) {
            HashSet<String> l = new HashSet<String>();
            StringTokenizer iter = new StringTokenizer(physicalName, ",");
            while (iter.hasMoreTokens()) {
                String name = iter.nextToken().trim();
                if (name.length() == 0) continue;
                l.add(name);
            }
            this.compositeDestinations = new BESMQDestination[l.size()];
            int counter = 0;
            for (String dest : l) {
                this.compositeDestinations[counter++] = this.createDestination(dest);
            }
        }
    }

    public BESMQDestination createDestination(String name) {
        return BESMQDestination.createDestination(name, this.getDestinationType());
    }

    public String[] getDestinationPaths() {
        if (this.destinationPaths != null) {
            return this.destinationPaths;
        }
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer iter = new StringTokenizer(this.physicalName, PATH_SEPERATOR);
        while (iter.hasMoreTokens()) {
            String name = iter.nextToken().trim();
            if (name.length() == 0) continue;
            l.add(name);
        }
        this.destinationPaths = new String[l.size()];
        l.toArray(this.destinationPaths);
        return this.destinationPaths;
    }

    public abstract byte getDestinationType();

    public boolean isQueue() {
        return false;
    }

    public boolean isTopic() {
        return false;
    }

    public boolean isTemporary() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BESMQDestination d = (BESMQDestination)o;
        return this.physicalName.equals(d.physicalName);
    }

    public int hashCode() {
        if (this.hashValue == 0) {
            this.hashValue = this.physicalName.hashCode();
        }
        return this.hashValue;
    }

    public String toString() {
        return this.getQualifiedName();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.getPhysicalName());
        out.writeObject(this.options);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setPhysicalName(in.readUTF());
        this.options = (Map)in.readObject();
    }

    public String getDestinationTypeAsString() {
        switch (this.getDestinationType()) {
            case 1: {
                return "Queue";
            }
            case 2: {
                return "Topic";
            }
            case 5: {
                return "TempQueue";
            }
            case 6: {
                return "TempTopic";
            }
        }
        throw new IllegalArgumentException("Invalid destination type: " + this.getDestinationType());
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    @Override
    public boolean isMarshallAware() {
        return false;
    }

    @Override
    public void buildFromProperties(Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        IntrospectionSupport.setProperties(this, properties);
    }

    @Override
    public void populateProperties(Properties props) {
        props.setProperty("physicalName", this.getPhysicalName());
    }

    public boolean isPattern() {
        return this.isPattern;
    }

    public static UnresolvedDestinationTransformer getUnresolvableDestinationTransformer() {
        return unresolvableDestinationTransformer;
    }

    public static void setUnresolvableDestinationTransformer(UnresolvedDestinationTransformer unresolvableDestinationTransformer) {
        BESMQDestination.unresolvableDestinationTransformer = unresolvableDestinationTransformer;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }
}

