/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.command;

import com.bes.mq.FileMessage;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.command.Message;
import com.bes.mq.file.FileSender;
import com.bes.mq.util.MarshallingSupport;
import java.io.File;
import java.util.HashMap;
import javax.jms.JMSException;

public class BESMQFileMessage
extends BESMQMessage
implements FileMessage {
    public static final byte DATA_STRUCTURE_TYPE = 41;
    private String filePath;
    private String fileName;

    public byte getDataStructureType() {
        return 41;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFile() throws JMSException {
        boolean fileNotFound = this.getBooleanProperty("BESMQ_FT_FILE_NOT_FOUND");
        if (fileNotFound) {
            throw new JMSException("Not found file in broker, the original file path: " + this.filePath);
        }
        return this.filePath;
    }

    public void setFile(String filePath) throws JMSException {
        this.checkReadOnlyBody();
        if (filePath == null || filePath.isEmpty()) {
            throw new JMSException("File can't be empty");
        }
        this.filePath = File.separatorChar == '\\' ? filePath.replaceAll("\\\\", "/") : filePath;
    }

    public Message copy() {
        BESMQFileMessage copy = new BESMQFileMessage();
        this.copy(copy);
        return copy;
    }

    private void copy(BESMQFileMessage copy) {
        super.copy(copy);
        copy.filePath = this.filePath;
        copy.fileName = this.fileName;
    }

    public void onSend() throws JMSException {
        FileSender sender = new FileSender(this);
        sender.sendFile();
        super.onSend();
    }

    public String toString() {
        String text = this.filePath;
        if (text != null) {
            text = MarshallingSupport.truncate64(text);
            HashMap<String, Object> overrideFields = new HashMap<String, Object>();
            overrideFields.put("filePath", text);
            return super.toString(overrideFields);
        }
        return super.toString();
    }
}

