/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.command;

import com.bes.mq.BESMQConnection;
import com.bes.mq.Message;
import com.bes.mq.ScheduledMessage;
import com.bes.mq.broker.scheduler.CronParser;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.MessageId;
import com.bes.mq.command.ProducerId;
import com.bes.mq.command.Response;
import com.bes.mq.filter.PropertyExpression;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.state.CommandVisitor;
import com.bes.mq.util.ByteSequence;
import com.bes.mq.util.Callback;
import com.bes.mq.util.JMSExceptionSupport;
import com.bes.mq.util.TypeConversionSupport;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BESMQMessage
extends com.bes.mq.command.Message
implements Message,
ScheduledMessage {
    public static final byte DATA_STRUCTURE_TYPE = 34;
    public static final String DLQ_DELIVERY_FAILURE_CAUSE_PROPERTY = "dlqDeliveryFailureCause";
    private static final Map<String, PropertySetter> JMS_PROPERTY_SETERS = new HashMap<String, PropertySetter>();
    protected transient Callback acknowledgeCallback;

    @Override
    public byte getDataStructureType() {
        return 34;
    }

    @Override
    public com.bes.mq.command.Message copy() {
        BESMQMessage copy = new BESMQMessage();
        this.copy(copy);
        return copy;
    }

    protected void copy(BESMQMessage copy) {
        super.copy(copy);
        copy.acknowledgeCallback = this.acknowledgeCallback;
    }

    public int hashCode() {
        MessageId id = this.getMessageId();
        if (id != null) {
            return id.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        BESMQMessage msg = (BESMQMessage)o;
        MessageId oMsg = msg.getMessageId();
        MessageId thisMsg = this.getMessageId();
        return thisMsg != null && oMsg != null && oMsg.equals(thisMsg);
    }

    @Override
    public void acknowledge() throws JMSException {
        if (this.acknowledgeCallback != null) {
            try {
                this.acknowledgeCallback.execute();
            }
            catch (JMSException e) {
                throw e;
            }
            catch (Throwable e) {
                throw JMSExceptionSupport.create(e);
            }
        }
    }

    @Override
    public void clearBody() throws JMSException {
        this.setContent(null);
        this.readOnlyBody = false;
    }

    @Override
    public String getJMSMessageID() {
        MessageId messageId = this.getMessageId();
        if (messageId == null) {
            return null;
        }
        return messageId.toString();
    }

    @Override
    public void setJMSMessageID(String value) throws JMSException {
        if (value != null) {
            try {
                MessageId id = new MessageId(value);
                this.setMessageId(id);
            }
            catch (NumberFormatException e) {
                MessageId id = new MessageId();
                id.setTextView(value);
                this.setMessageId(this.messageId);
            }
        } else {
            this.setMessageId(null);
        }
    }

    public void setJMSMessageID(ProducerId producerId, long producerSequenceId) throws JMSException {
        MessageId id = null;
        try {
            id = new MessageId(producerId, producerSequenceId);
            this.setMessageId(id);
        }
        catch (Throwable e) {
            throw JMSExceptionSupport.create("Invalid message id '" + id + "', reason: " + e.getMessage(), e);
        }
    }

    @Override
    public long getJMSTimestamp() {
        return this.getTimestamp();
    }

    @Override
    public void setJMSTimestamp(long timestamp) {
        this.setTimestamp(timestamp);
    }

    @Override
    public String getJMSCorrelationID() {
        return this.getCorrelationId();
    }

    @Override
    public void setJMSCorrelationID(String correlationId) {
        this.setCorrelationId(correlationId);
    }

    @Override
    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return BESMQMessage.encodeString(this.getCorrelationId());
    }

    @Override
    public void setJMSCorrelationIDAsBytes(byte[] correlationId) throws JMSException {
        this.setCorrelationId(BESMQMessage.decodeString(correlationId));
    }

    protected boolean isEncrypted() throws IOException {
        Boolean encrypted = (Boolean)this.getProperty("BESMQ_ENCRYPTED");
        return encrypted != null && encrypted != false;
    }

    protected void setEncrypted(boolean encrypted) throws IOException {
        if (encrypted) {
            this.setProperty("BESMQ_ENCRYPTED", Boolean.TRUE);
        } else {
            this.removeProperty("BESMQ_ENCRYPTED");
        }
    }

    @Override
    public String getJMSXMimeType() {
        return "jms/message";
    }

    protected static String decodeString(byte[] data) throws JMSException {
        try {
            if (data == null) {
                return null;
            }
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JMSException("Invalid UTF-8 encoding: " + e.getMessage());
        }
    }

    protected static byte[] encodeString(String data) throws JMSException {
        try {
            if (data == null) {
                return null;
            }
            return data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JMSException("Invalid UTF-8 encoding: " + e.getMessage());
        }
    }

    @Override
    public Destination getJMSReplyTo() {
        return this.getReplyTo();
    }

    @Override
    public void setJMSReplyTo(Destination destination) throws JMSException {
        this.setReplyTo(BESMQDestination.transform(destination));
    }

    @Override
    public Destination getJMSDestination() {
        return this.getDestination();
    }

    @Override
    public void setJMSDestination(Destination destination) throws JMSException {
        this.setDestination(BESMQDestination.transform(destination));
    }

    @Override
    public int getJMSDeliveryMode() {
        return this.isPersistent() ? 2 : 1;
    }

    @Override
    public void setJMSDeliveryMode(int mode) {
        this.setPersistent(mode == 2);
    }

    @Override
    public boolean getJMSRedelivered() {
        return this.isRedelivered();
    }

    @Override
    public void setJMSRedelivered(boolean redelivered) {
        this.setRedelivered(redelivered);
    }

    @Override
    public String getJMSType() {
        return this.getType();
    }

    @Override
    public void setJMSType(String type) {
        this.setType(type);
    }

    @Override
    public long getJMSExpiration() {
        return this.getExpiration();
    }

    @Override
    public void setJMSExpiration(long expiration) {
        this.setExpiration(expiration);
    }

    @Override
    public int getJMSPriority() {
        return this.getPriority();
    }

    @Override
    public void setJMSPriority(int priority) {
        this.setPriority((byte)priority);
    }

    @Override
    public void clearProperties() {
        super.clearProperties();
        this.readOnlyProperties = false;
    }

    @Override
    public boolean propertyExists(String name) throws JMSException {
        try {
            return this.getProperties().containsKey(name) || this.getObjectProperty(name) != null;
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    @Override
    public Enumeration getPropertyNames() throws JMSException {
        try {
            Vector<String> result = new Vector<String>(this.getProperties().keySet());
            if (!result.contains("JMSXDeliveryCount")) {
                result.add("JMSXDeliveryCount");
            }
            return result.elements();
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    public Enumeration getAllPropertyNames() throws JMSException {
        try {
            Vector<String> result = new Vector<String>(this.getProperties().keySet());
            result.addAll(JMS_PROPERTY_SETERS.keySet());
            return result.elements();
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    @Override
    public void setObjectProperty(String name, Object value) throws JMSException {
        this.setObjectProperty(name, value, true);
    }

    public void setObjectProperty(String name, Object value, boolean checkReadOnly) throws JMSException {
        if (checkReadOnly) {
            this.checkReadOnlyProperties();
        }
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Property name cannot be empty or null");
        }
        this.checkValidObject(value);
        value = this.convertScheduled(name, value);
        PropertySetter setter = JMS_PROPERTY_SETERS.get(name);
        if (setter != null && value != null) {
            setter.set(this, value);
        } else {
            try {
                this.setProperty(name, value);
            }
            catch (IOException e) {
                throw JMSExceptionSupport.create(e);
            }
        }
    }

    public void setProperties(Map<String, ?> properties) throws JMSException {
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            this.setObjectProperty(entry.getKey(), entry.getValue());
        }
    }

    protected void checkValidObject(Object value) throws MessageFormatException {
        boolean valid = value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long;
        boolean bl = valid = valid || value instanceof Float || value instanceof Double || value instanceof Character || value instanceof String || value == null;
        if (!valid) {
            BESMQConnection conn = this.getConnection();
            if (conn == null || conn.isNestedMapAndListEnabled()) {
                if (!(value instanceof Map) && !(value instanceof List)) {
                    throw new MessageFormatException("Only objectified primitive objects, String, Map and List types are allowed but was: " + value + " type: " + value.getClass());
                }
            } else {
                throw new MessageFormatException("Only objectified primitive objects and String types are allowed but was: " + value + " type: " + value.getClass());
            }
        }
    }

    protected void checkValidScheduled(String name, Object value) throws MessageFormatException {
        if (("BMQ_SCHEDULED_DELAY".equals(name) || "BMQ_SCHEDULED_PERIOD".equals(name) || "BMQ_SCHEDULED_REPEAT".equals(name)) && !(value instanceof Long) && !(value instanceof Integer)) {
            throw new MessageFormatException(name + " should be long or int value");
        }
        if ("BMQ_SCHEDULED_CRON".equals(name)) {
            CronParser.validate(value.toString());
        }
    }

    protected Object convertScheduled(String name, Object value) throws MessageFormatException {
        Object result = value;
        if ("BMQ_SCHEDULED_DELAY".equals(name)) {
            result = TypeConversionSupport.convert(value, Long.class);
        } else if ("BMQ_SCHEDULED_PERIOD".equals(name)) {
            result = TypeConversionSupport.convert(value, Long.class);
        } else if ("BMQ_SCHEDULED_REPEAT".equals(name)) {
            result = TypeConversionSupport.convert(value, Integer.class);
        }
        return result;
    }

    @Override
    public Object getObjectProperty(String name) throws JMSException {
        if (name == null) {
            throw new NullPointerException("Property name cannot be null");
        }
        PropertyExpression expression = new PropertyExpression(name);
        return expression.evaluate(this);
    }

    @Override
    public boolean getBooleanProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            return false;
        }
        Boolean rc = (Boolean)TypeConversionSupport.convert(value, Boolean.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a boolean");
        }
        return rc;
    }

    @Override
    public byte getByteProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("property " + name + " was null");
        }
        Byte rc = (Byte)TypeConversionSupport.convert(value, Byte.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a byte");
        }
        return rc;
    }

    @Override
    public short getShortProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("property " + name + " was null");
        }
        Short rc = (Short)TypeConversionSupport.convert(value, Short.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a short");
        }
        return rc;
    }

    @Override
    public int getIntProperty(String name) throws JMSException {
        if (name.equals("JMSXGroupSeq")) {
            return this.getGroupSequence();
        }
        if (name.equals("JMSXDeliveryCount")) {
            return this.getRedeliveryCounter() + 1;
        }
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("property " + name + " was null");
        }
        Integer rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as an integer");
        }
        return rc;
    }

    @Override
    public long getLongProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("property " + name + " was null");
        }
        Long rc = (Long)TypeConversionSupport.convert(value, Long.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a long");
        }
        return rc;
    }

    @Override
    public float getFloatProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NullPointerException("property " + name + " was null");
        }
        Float rc = (Float)TypeConversionSupport.convert(value, Float.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a float");
        }
        return rc.floatValue();
    }

    @Override
    public double getDoubleProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NullPointerException("property " + name + " was null");
        }
        Double rc = (Double)TypeConversionSupport.convert(value, Double.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a double");
        }
        return rc;
    }

    @Override
    public String getStringProperty(String name) throws JMSException {
        Object value = null;
        if (name.equals("JMSXUserID")) {
            value = this.getUserID();
            if (value == null) {
                value = this.getObjectProperty(name);
            }
        } else if (name.equals("JMSXGroupID")) {
            value = this.getGroupID();
            if (value == null) {
                value = this.getObjectProperty(name);
            }
        } else {
            value = this.getObjectProperty(name);
        }
        if (value == null) {
            return null;
        }
        String rc = (String)TypeConversionSupport.convert(value, String.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a String");
        }
        return rc;
    }

    @Override
    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.setBooleanProperty(name, value, true);
    }

    public void setBooleanProperty(String name, boolean value, boolean checkReadOnly) throws JMSException {
        this.setObjectProperty(name, value, checkReadOnly);
    }

    @Override
    public void setByteProperty(String name, byte value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    @Override
    public void setShortProperty(String name, short value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    @Override
    public void setIntProperty(String name, int value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    @Override
    public void setLongProperty(String name, long value) throws JMSException {
        this.setObjectProperty(name, value, true);
    }

    @Override
    public void setFloatProperty(String name, float value) throws JMSException {
        this.setObjectProperty(name, new Float(value));
    }

    @Override
    public void setDoubleProperty(String name, double value) throws JMSException {
        this.setObjectProperty(name, new Double(value));
    }

    @Override
    public void setStringProperty(String name, String value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    private void checkReadOnlyProperties() throws MessageNotWriteableException {
        if (this.readOnlyProperties) {
            throw new MessageNotWriteableException("Message properties are read-only");
        }
    }

    protected void checkReadOnlyBody() throws MessageNotWriteableException {
        if (this.readOnlyBody) {
            throw new MessageNotWriteableException("Message body is read-only");
        }
    }

    public Callback getAcknowledgeCallback() {
        return this.acknowledgeCallback;
    }

    public void setAcknowledgeCallback(Callback acknowledgeCallback) {
        this.acknowledgeCallback = acknowledgeCallback;
    }

    public void onSend() throws JMSException {
        this.setReadOnlyBody(true);
        this.setReadOnlyProperties(true);
    }

    @Override
    public Response visit(CommandVisitor visitor) throws Exception {
        return visitor.processMessage(this);
    }

    @Override
    public void storeContent() {
    }

    @Override
    public void beforeMarshall(ProtocolFormat protocolFormat) throws IOException {
        BESMQConnection connection = this.getConnection();
        if (connection != null && connection.isUseEncryption() && !this.isEncrypted()) {
            this.setEncrypted(true);
        }
        super.beforeMarshall(protocolFormat);
    }

    protected ByteSequence encrypt(ByteSequence content) throws JMSException {
        BESMQConnection connection = this.getConnection();
        if (connection != null && connection.isUseEncryption()) {
            content = connection.getMessageEncryptor().encrypt(content);
        }
        return content;
    }

    protected ByteSequence decrypt(ByteSequence content) throws JMSException {
        try {
            if (this.isEncrypted()) {
                BESMQConnection connection = this.getConnection();
                if (connection != null && connection.isUseEncryption()) {
                    content = connection.getMessageEncryptor().decrypt(content);
                } else if (this.isCompressed()) {
                    throw new JMSException("Message has compressed and encrypted, can't only uncompress it here");
                }
            }
            this.setEncrypted(false);
            return content;
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create("Failed to decrypt message", e);
        }
    }

    static {
        JMS_PROPERTY_SETERS.put("JMSXDeliveryCount", new PropertySetter(){

            public void set(com.bes.mq.command.Message message, Object value) throws MessageFormatException {
                Integer rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSXDeliveryCount cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setRedeliveryCounter(rc - 1);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSXGroupID", new PropertySetter(){

            public void set(com.bes.mq.command.Message message, Object value) throws MessageFormatException {
                String rc = (String)TypeConversionSupport.convert(value, String.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSXGroupID cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setGroupID(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSXGroupSeq", new PropertySetter(){

            public void set(com.bes.mq.command.Message message, Object value) throws MessageFormatException {
                Integer rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSXGroupSeq cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setGroupSequence(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSCorrelationID", new PropertySetter(){

            public void set(com.bes.mq.command.Message message, Object value) throws MessageFormatException {
                String rc = (String)TypeConversionSupport.convert(value, String.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSCorrelationID cannot be set from a " + value.getClass().getName() + ".");
                }
                ((BESMQMessage)message).setJMSCorrelationID(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSDeliveryMode", new PropertySetter(){

            public void set(com.bes.mq.command.Message message, Object value) throws MessageFormatException {
                Integer rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
                if (rc == null) {
                    Boolean bool = (Boolean)TypeConversionSupport.convert(value, Boolean.class);
                    if (bool == null) {
                        throw new MessageFormatException("Property JMSDeliveryMode cannot be set from a " + value.getClass().getName() + ".");
                    }
                    rc = bool != false ? 2 : 1;
                }
                ((BESMQMessage)message).setJMSDeliveryMode(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSExpiration", new PropertySetter(){

            public void set(com.bes.mq.command.Message message, Object value) throws MessageFormatException {
                Long rc = (Long)TypeConversionSupport.convert(value, Long.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSExpiration cannot be set from a " + value.getClass().getName() + ".");
                }
                ((BESMQMessage)message).setJMSExpiration(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSPriority", new PropertySetter(){

            public void set(com.bes.mq.command.Message message, Object value) throws MessageFormatException {
                Integer rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSPriority cannot be set from a " + value.getClass().getName() + ".");
                }
                ((BESMQMessage)message).setJMSPriority(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSRedelivered", new PropertySetter(){

            public void set(com.bes.mq.command.Message message, Object value) throws MessageFormatException {
                Boolean rc = (Boolean)TypeConversionSupport.convert(value, Boolean.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSRedelivered cannot be set from a " + value.getClass().getName() + ".");
                }
                ((BESMQMessage)message).setJMSRedelivered(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSReplyTo", new PropertySetter(){

            public void set(com.bes.mq.command.Message message, Object value) throws MessageFormatException {
                BESMQDestination rc = (BESMQDestination)TypeConversionSupport.convert(value, BESMQDestination.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSReplyTo cannot be set from a " + value.getClass().getName() + ".");
                }
                ((BESMQMessage)message).setReplyTo(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSTimestamp", new PropertySetter(){

            public void set(com.bes.mq.command.Message message, Object value) throws MessageFormatException {
                Long rc = (Long)TypeConversionSupport.convert(value, Long.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSTimestamp cannot be set from a " + value.getClass().getName() + ".");
                }
                ((BESMQMessage)message).setJMSTimestamp(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSType", new PropertySetter(){

            public void set(com.bes.mq.command.Message message, Object value) throws MessageFormatException {
                String rc = (String)TypeConversionSupport.convert(value, String.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSType cannot be set from a " + value.getClass().getName() + ".");
                }
                ((BESMQMessage)message).setJMSType(rc);
            }
        });
    }

    static interface PropertySetter {
        public void set(com.bes.mq.command.Message var1, Object var2) throws MessageFormatException;
    }
}

