/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.command;

import com.bes.mq.BESMQConnection;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import javax.jms.JMSException;

public abstract class BESMQTempDestination
extends BESMQDestination {
    private static final Logger LOG = LoggerFactory.getLogger(BESMQTempDestination.class);
    protected transient BESMQConnection connection;
    protected transient String connectionId;
    protected transient int sequenceId;

    public BESMQTempDestination() {
    }

    public BESMQTempDestination(String name) {
        super(name);
    }

    public BESMQTempDestination(String connectionId, long sequenceId) {
        super(connectionId + ":" + sequenceId);
    }

    public boolean isTemporary() {
        return true;
    }

    public void delete() throws JMSException {
        if (this.connection != null) {
            this.connection.deleteTempDestination(this);
        }
    }

    public BESMQConnection getConnection() {
        return this.connection;
    }

    public void setConnection(BESMQConnection connection) {
        this.connection = connection;
    }

    public void setPhysicalName(String physicalName) {
        String seqStr;
        int p;
        super.setPhysicalName(physicalName);
        if (!this.isComposite() && (p = this.physicalName.lastIndexOf(":")) >= 0 && (seqStr = this.physicalName.substring(p + 1).trim()) != null && seqStr.length() > 0) {
            try {
                this.sequenceId = Integer.parseInt(seqStr);
            }
            catch (NumberFormatException e) {
                LOG.debug("Did not parse sequence Id from " + physicalName);
            }
            this.connectionId = this.physicalName.substring(0, p);
        }
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }
}

