/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.command;

import com.bes.mq.BESMQConnection;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.command.Message;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.util.ByteArrayInputStream;
import com.bes.mq.util.ByteArrayOutputStream;
import com.bes.mq.util.ByteSequence;
import com.bes.mq.util.JMSExceptionSupport;
import com.bes.mq.util.MarshallingSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import javax.jms.TextMessage;

public class BESMQTextMessage
extends BESMQMessage
implements TextMessage {
    public static final byte DATA_STRUCTURE_TYPE = 39;
    protected String text;

    public Message copy() {
        BESMQTextMessage copy = new BESMQTextMessage();
        this.copy(copy);
        return copy;
    }

    private void copy(BESMQTextMessage copy) {
        super.copy(copy);
        copy.text = this.text;
    }

    public byte getDataStructureType() {
        return 39;
    }

    public String getJMSXMimeType() {
        return "jms/text-message";
    }

    public void setText(String text) throws MessageNotWriteableException {
        this.checkReadOnlyBody();
        this.text = text;
        this.setContent(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getText() throws JMSException {
        if (this.text != null) return this.text;
        if (this.getContent() == null) return this.text;
        InputStream is = null;
        try {
            try {
                ByteSequence bodyAsBytes = this.getContent();
                if (bodyAsBytes != null) {
                    bodyAsBytes = this.decrypt(bodyAsBytes);
                    is = new ByteArrayInputStream(bodyAsBytes);
                    if (this.isCompressed()) {
                        is = new InflaterInputStream(is);
                    }
                    DataInputStream dataIn = new DataInputStream(is);
                    this.text = MarshallingSupport.readUTF8(dataIn);
                    dataIn.close();
                    this.setContent(null);
                    this.setCompressed(false);
                }
            }
            catch (IOException ioe) {
                throw JMSExceptionSupport.create(ioe);
            }
            Object var5_5 = null;
            if (is == null) return this.text;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        is.close();
        return this.text;
    }

    public void beforeMarshall(ProtocolFormat protocolFormat) throws IOException {
        super.beforeMarshall(protocolFormat);
        this.storeContent();
    }

    public void storeContent() {
        try {
            ByteSequence content = this.getContent();
            if (content == null && this.text != null) {
                ByteArrayOutputStream bytesOut;
                OutputStream os = bytesOut = new ByteArrayOutputStream();
                BESMQConnection connection = this.getConnection();
                if (connection != null && connection.isUseCompression()) {
                    this.compressed = true;
                    os = new DeflaterOutputStream(os);
                }
                DataOutputStream dataOut = new DataOutputStream(os);
                MarshallingSupport.writeUTF8(dataOut, this.text);
                dataOut.close();
                content = this.encrypt(bytesOut.toByteSequence());
                this.setContent(content);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void clearMarshalledState() throws JMSException {
        super.clearMarshalledState();
        this.text = null;
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.text = null;
    }

    public int getSize() {
        if (this.size == 0 && this.content == null && this.text != null) {
            this.size = this.getMinimumMessageSize();
            if (this.marshalledProperties != null) {
                this.size += this.marshalledProperties.getLength();
            }
            this.size += this.text.length() * 2;
        }
        return super.getSize();
    }

    public String toString() {
        try {
            String text = this.getText();
            if (text != null) {
                text = MarshallingSupport.truncate64(text);
                HashMap<String, Object> overrideFields = new HashMap<String, Object>();
                overrideFields.put("text", text);
                return super.toString(overrideFields);
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return super.toString();
    }
}

