/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.command;

import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BaseCommand;
import com.bes.mq.command.BrokerId;
import com.bes.mq.command.ConnectionId;
import com.bes.mq.command.Response;
import com.bes.mq.state.CommandVisitor;
import java.io.IOException;

public class DestinationInfo
extends BaseCommand {
    public static final byte DATA_STRUCTURE_TYPE = 7;
    public static final byte ADD_OPERATION_TYPE = 0;
    public static final byte REMOVE_OPERATION_TYPE = 1;
    protected ConnectionId connectionId;
    protected BESMQDestination destination;
    protected byte operationType;
    protected long timeout;
    protected BrokerId[] brokerPath;

    public DestinationInfo() {
    }

    public DestinationInfo(ConnectionId connectionId, byte operationType, BESMQDestination destination) {
        this.connectionId = connectionId;
        this.operationType = operationType;
        this.destination = destination;
    }

    public byte getDataStructureType() {
        return 7;
    }

    public boolean isAddOperation() {
        return this.operationType == 0;
    }

    public boolean isRemoveOperation() {
        return this.operationType == 1;
    }

    public ConnectionId getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(ConnectionId connectionId) {
        this.connectionId = connectionId;
    }

    public BESMQDestination getDestination() {
        return this.destination;
    }

    public void setDestination(BESMQDestination destination) {
        this.destination = destination;
    }

    public byte getOperationType() {
        return this.operationType;
    }

    public void setOperationType(byte operationType) {
        this.operationType = operationType;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public BrokerId[] getBrokerPath() {
        return this.brokerPath;
    }

    public void setBrokerPath(BrokerId[] brokerPath) {
        this.brokerPath = brokerPath;
    }

    public Response visit(CommandVisitor visitor) throws Exception {
        if (this.isAddOperation()) {
            return visitor.processAddDestination(this);
        }
        if (this.isRemoveOperation()) {
            return visitor.processRemoveDestination(this);
        }
        throw new IOException("Unknown operation type: " + this.getOperationType());
    }

    public DestinationInfo copy() {
        DestinationInfo result = new DestinationInfo();
        super.copy(result);
        result.connectionId = this.connectionId;
        result.destination = this.destination;
        result.operationType = this.operationType;
        result.brokerPath = this.brokerPath;
        return result;
    }
}

