/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.command;

import com.bes.mq.command.BrokerId;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.DataStructure;
import com.bes.mq.command.Message;
import com.bes.mq.filter.BooleanExpression;
import com.bes.mq.filter.MessageEvaluationContext;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.util.JMSExceptionSupport;
import java.io.IOException;
import java.util.Arrays;
import javax.jms.JMSException;

public class NetworkBridgeFilter
implements DataStructure,
BooleanExpression {
    public static final byte DATA_STRUCTURE_TYPE = 71;
    static final Logger LOG = LoggerFactory.getLogger(NetworkBridgeFilter.class);
    protected BrokerId networkBrokerId;
    protected int networkTTL;

    public NetworkBridgeFilter() {
    }

    public NetworkBridgeFilter(BrokerId networkBrokerId, int networkTTL) {
        this.networkBrokerId = networkBrokerId;
        this.networkTTL = networkTTL;
    }

    public byte getDataStructureType() {
        return 71;
    }

    public boolean isMarshallAware() {
        return false;
    }

    public boolean matches(MessageEvaluationContext mec) throws JMSException {
        try {
            Message message = mec.getMessage();
            return message != null && this.matchesForwardingFilter(message, mec);
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    public Object evaluate(MessageEvaluationContext message) throws JMSException {
        return this.matches(message) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected boolean matchesForwardingFilter(Message message, MessageEvaluationContext mec) {
        int hops;
        if (NetworkBridgeFilter.contains(message.getBrokerPath(), this.networkBrokerId)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Message already routed once through target broker (" + this.networkBrokerId + "), path: " + Arrays.toString(message.getBrokerPath()) + " - ignoring: " + message);
            }
            return false;
        }
        int n = hops = message.getBrokerPath() == null ? 0 : message.getBrokerPath().length;
        if (hops >= this.networkTTL) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Message restricted to " + this.networkTTL + " network hops ignoring: " + message);
            }
            return false;
        }
        if (message.isNotification() && message.getDataStructure() != null && message.getDataStructure().getDataStructureType() == 4) {
            ConsumerInfo info = (ConsumerInfo)message.getDataStructure();
            int n2 = hops = info.getBrokerPath() == null ? 0 : info.getBrokerPath().length;
            if (hops >= this.networkTTL) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("ConsumerInfo notification restricted to " + this.networkTTL + " network hops ignoring: " + message);
                }
                return false;
            }
            if (NetworkBridgeFilter.contains(info.getBrokerPath(), this.networkBrokerId)) {
                LOG.trace("ConsumerInfo notification already routed once through target broker (" + this.networkBrokerId + "), path: " + Arrays.toString(info.getBrokerPath()) + " - ignoring: " + message);
                return false;
            }
        }
        return true;
    }

    public static boolean contains(BrokerId[] brokerPath, BrokerId brokerId) {
        if (brokerPath != null && brokerId != null) {
            for (int i = 0; i < brokerPath.length; ++i) {
                if (!brokerId.equals(brokerPath[i])) continue;
                return true;
            }
        }
        return false;
    }

    public int getNetworkTTL() {
        return this.networkTTL;
    }

    public void setNetworkTTL(int networkTTL) {
        this.networkTTL = networkTTL;
    }

    public BrokerId getNetworkBrokerId() {
        return this.networkBrokerId;
    }

    public void setNetworkBrokerId(BrokerId remoteBrokerPath) {
        this.networkBrokerId = remoteBrokerPath;
    }
}

