/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.command;

import com.bes.mq.command.BaseCommand;
import com.bes.mq.command.ConnectionId;
import com.bes.mq.command.ConsumerId;
import com.bes.mq.command.DataStructure;
import com.bes.mq.command.ProducerId;
import com.bes.mq.command.Response;
import com.bes.mq.command.SessionId;
import com.bes.mq.state.CommandVisitor;
import java.io.IOException;

public class RemoveInfo
extends BaseCommand {
    public static final byte DATA_STRUCTURE_TYPE = 16;
    protected DataStructure objectId;
    protected long lastDeliveredSequenceId;

    public RemoveInfo() {
    }

    public RemoveInfo(DataStructure objectId) {
        this.objectId = objectId;
    }

    public byte getDataStructureType() {
        return 16;
    }

    public DataStructure getObjectId() {
        return this.objectId;
    }

    public void setObjectId(DataStructure objectId) {
        this.objectId = objectId;
    }

    public long getLastDeliveredSequenceId() {
        return this.lastDeliveredSequenceId;
    }

    public void setLastDeliveredSequenceId(long lastDeliveredSequenceId) {
        this.lastDeliveredSequenceId = lastDeliveredSequenceId;
    }

    public Response visit(CommandVisitor visitor) throws Exception {
        switch (this.objectId.getDataStructureType()) {
            case 100: {
                return visitor.processRemoveConnection((ConnectionId)this.objectId, this.lastDeliveredSequenceId);
            }
            case 101: {
                return visitor.processRemoveSession((SessionId)this.objectId, this.lastDeliveredSequenceId);
            }
            case 102: {
                return visitor.processRemoveConsumer((ConsumerId)this.objectId, this.lastDeliveredSequenceId);
            }
            case 103: {
                return visitor.processRemoveProducer((ProducerId)this.objectId);
            }
        }
        throw new IOException("Unknown remove command type: " + this.objectId.getDataStructureType());
    }

    public boolean isConnectionRemove() {
        return this.objectId.getDataStructureType() == 100;
    }

    public boolean isSessionRemove() {
        return this.objectId.getDataStructureType() == 101;
    }

    public boolean isConsumerRemove() {
        return this.objectId.getDataStructureType() == 102;
    }

    public boolean isProducerRemove() {
        return this.objectId.getDataStructureType() == 103;
    }
}

