/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.common.universal.net;

import com.bes.mq.common.universal.net.NetUtils;
import com.bes.mq.common.universal.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;
import java.util.StringTokenizer;

public class NetUtils {
    public static final int MAX_PORT = 65535;
    private static final boolean asDebug = Boolean.parseBoolean(System.getenv("AS_DEBUG"));
    private static final String LOCALHOST_IP = "127.0.0.1";
    private static byte[] TEST_QUERY = new byte[]{22, 3, 0, 0, 83, 1, 0, 0, 79, 3, 0, 63, 71, -41, -9, -70, 44, -18, -22, -78, 96, 126, -13, 0, -3, -126, 123, -71, -43, -106, -56, 119, -101, -26, -60, -37, 60, 61, -37, 111, -17, 16, 110, 0, 0, 40, 0, 22, 0, 19, 0, 10, 0, 102, 0, 5, 0, 4, 0, 101, 0, 100, 0, 99, 0, 98, 0, 97, 0, 96, 0, 21, 0, 18, 0, 9, 0, 20, 0, 17, 0, 8, 0, 6, 0, 3, 1, 0, 71, 69, 84, 32, 47, 32, 72, 84, 84, 80, 47, 49, 46, 48, 10, 10};

    private static void printd(String string) {
        if (asDebug) {
            System.out.println(string);
        }
    }

    private NetUtils() {
    }

    public static boolean isThisHostLocal(String hostname) {
        if (hostname == null || hostname.length() == 0 || hostname.equalsIgnoreCase("localhost")) {
            return true;
        }
        InetAddress[] hostAddrs = null;
        try {
            InetAddress[] localHostAddrs;
            hostAddrs = InetAddress.getAllByName(hostname);
            if (hostAddrs != null) {
                for (InetAddress ia : hostAddrs) {
                    if (!ia.isLoopbackAddress()) continue;
                    return true;
                }
            }
            if ((localHostAddrs = InetAddress.getAllByName("localhost")) != null && hostAddrs != null) {
                for (InetAddress lia : localHostAddrs) {
                    for (InetAddress ia : hostAddrs) {
                        if (!lia.equals(ia)) continue;
                        return true;
                    }
                }
            }
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        Enumeration<NetworkInterface> eni = null;
        try {
            eni = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            // empty catch block
        }
        if (eni != null && hostAddrs != null) {
            while (eni.hasMoreElements()) {
                NetworkInterface ni = eni.nextElement();
                for (InterfaceAddress intf : ni.getInterfaceAddresses()) {
                    for (InetAddress ia : hostAddrs) {
                        if (!intf.getAddress().equals(ia)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean isEqual(String host1, String host2) {
        ArrayList<String> host1_ips = new ArrayList<String>();
        ArrayList<String> host2_ips = new ArrayList<String>();
        try {
            if (!StringUtils.ok(host1) && !StringUtils.ok(host2)) {
                return true;
            }
            if (!StringUtils.ok(host1) || !StringUtils.ok(host2)) {
                return false;
            }
            InetAddress[] adds1 = InetAddress.getAllByName(host1);
            InetAddress[] adds2 = InetAddress.getAllByName(host2);
            boolean adds1Empty = false;
            boolean adds2Empty = false;
            if (adds1 == null || adds1.length <= 0) {
                adds1Empty = true;
            }
            if (adds2 == null || adds2.length <= 0) {
                adds2Empty = true;
            }
            if (adds1Empty && adds2Empty) {
                return true;
            }
            if (adds1Empty || adds2Empty) {
                return false;
            }
            for (InetAddress ia : adds1) {
                host1_ips.add(ia.getHostAddress());
            }
            for (InetAddress ia : adds2) {
                host2_ips.add(ia.getHostAddress());
            }
            for (String h1ip : host1_ips) {
                for (String h2ip : host2_ips) {
                    if (!h1ip.equals(h2ip)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (UnknownHostException ex) {
            return false;
        }
    }

    public static Socket getClientSocket(String host, int port, int msecTimeout) {
        SocketFetcher fetcher = new SocketFetcher(host, port);
        Thread t = new Thread((Runnable)fetcher);
        t.start();
        try {
            t.join(msecTimeout);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return fetcher.getSocket();
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getCanonicalHostName() throws UnknownHostException {
        String hostname = null;
        String defaultHostname = InetAddress.getLocalHost().getHostName();
        if (Boolean.parseBoolean(System.getenv("AS_NO_REVERSE_DNS"))) {
            return defaultHostname;
        }
        hostname = InetAddress.getLocalHost().getCanonicalHostName();
        if (hostname.equals(InetAddress.getLocalHost().getHostAddress()) || !hostname.startsWith(defaultHostname)) {
            hostname = defaultHostname;
        }
        return hostname;
    }

    public static InetAddress[] getHostAddresses() {
        try {
            String hname = NetUtils.getHostName();
            if (hname == null) {
                return null;
            }
            return InetAddress.getAllByName(hname);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String[] getHostIPs() {
        try {
            InetAddress[] adds = NetUtils.getHostAddresses();
            if (adds == null) {
                return null;
            }
            String[] ips = new String[adds.length];
            for (int i = 0; i < adds.length; ++i) {
                String ip;
                ips[i] = ip = NetUtils.trimIP(adds[i].toString());
            }
            return ips;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String trimIP(String ip) {
        if (ip == null || ip.length() <= 0) {
            return ip;
        }
        int index = ip.lastIndexOf(47);
        if (index >= 0) {
            return ip.substring(++index);
        }
        return ip;
    }

    public static byte[] ip2bytes(String ip) {
        try {
            ip = NetUtils.trimIP(ip);
            StringTokenizer stk = new StringTokenizer(ip, ".");
            byte[] bytes = new byte[stk.countTokens()];
            int i = 0;
            while (stk.hasMoreTokens()) {
                String num = stk.nextToken();
                int inum = Integer.parseInt(num);
                bytes[i] = (byte)inum;
                ++i;
            }
            return bytes;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static boolean isLocalHost(String ip) {
        if (ip == null) {
            return false;
        }
        ip = NetUtils.trimIP(ip);
        return ip.equals(LOCALHOST_IP);
    }

    public static boolean isLocal(String ip) {
        if (ip == null) {
            return false;
        }
        if (NetUtils.isLocalHost(ip = NetUtils.trimIP(ip))) {
            return true;
        }
        String[] myIPs = NetUtils.getHostIPs();
        if (myIPs == null) {
            return false;
        }
        for (int i = 0; i < myIPs.length; ++i) {
            if (!ip.equals(myIPs[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isLocalAddress(String ip) {
        boolean isLocalAdrress = false;
        String address = null;
        Enumeration<NetworkInterface> allNetInterfaces = null;
        try {
            address = InetAddress.getByName(ip).getHostAddress();
            allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress netip = null;
            String localAddress = null;
            boolean breakFlag = false;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    netip = addresses.nextElement();
                    if (netip == null) continue;
                    localAddress = netip.getHostAddress();
                    if (localAddress.indexOf(37) != -1) {
                        if (localAddress.split("%")[0].equalsIgnoreCase(address)) {
                            isLocalAdrress = true;
                            breakFlag = true;
                            break;
                        }
                        if (!localAddress.equalsIgnoreCase(address)) continue;
                        isLocalAdrress = true;
                        breakFlag = true;
                        break;
                    }
                    if (!localAddress.equalsIgnoreCase(address)) continue;
                    isLocalAdrress = true;
                    breakFlag = true;
                    break;
                }
                if (!breakFlag) continue;
                break;
            }
        }
        catch (Exception e) {
            isLocalAdrress = false;
        }
        if ("0.0.0.0".equals(ip)) {
            isLocalAdrress = true;
        }
        return isLocalAdrress;
    }

    public static boolean isRemote(String ip) {
        return !NetUtils.isLocal(ip);
    }

    public static int getNextFreePort(String hostName, int port) {
        while (port++ < 65535) {
            if (!NetUtils.isPortFree(hostName, port)) continue;
            return port;
        }
        return 0;
    }

    public static int getFreePort(String hostName, int startingPort, int endingPort) {
        int port;
        block1: {
            int range = endingPort - startingPort;
            port = 0;
            if (range <= 0) break block1;
            Random r = new Random();
            while (!NetUtils.isPortFree(hostName, port = r.nextInt(range + 1) + startingPort)) {
            }
        }
        return port;
    }

    public static boolean isPortValid(int portNumber) {
        return portNumber >= 0 && portNumber <= 65535;
    }

    public static boolean isPortStringValid(String portNumber) {
        try {
            return NetUtils.isPortValid(Integer.parseInt(portNumber));
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public static boolean isPortFree(String hostName, int portNumber) {
        if (portNumber <= 0 || portNumber > 65535) {
            return false;
        }
        if (hostName == null || NetUtils.isLocalAddress(hostName)) {
            return NetUtils.isPortFreeServer(portNumber);
        }
        return NetUtils.isPortFreeClient(hostName, portNumber);
    }

    public static PortAvailability checkPort(int portNumber) {
        if (!NetUtils.isPortValid(portNumber)) {
            return PortAvailability.illegalNumber;
        }
        if (NetUtils.isPortFreeServer(portNumber)) {
            return PortAvailability.OK;
        }
        if (NetUtils.isPortFreeClient(null, portNumber)) {
            return PortAvailability.noPermission;
        }
        return PortAvailability.inUse;
    }

    public static boolean isPortFree(int portNumber) {
        return NetUtils.isPortFree(null, portNumber);
    }

    private static boolean isPortFreeClient(String hostName, int portNumber) {
        try {
            if (hostName == null) {
                hostName = NetUtils.getHostName();
            }
            Socket socket = new Socket(hostName, portNumber);
            OutputStream os = socket.getOutputStream();
            InputStream is = socket.getInputStream();
            os.close();
            os = null;
            is.close();
            is = null;
            socket.close();
            socket = null;
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    private static boolean isPortFreeServer(int port) {
        try {
            byte[] allZero = new byte[]{0, 0, 0, 0};
            InetAddress add = InetAddress.getByAddress(allZero);
            if (!NetUtils.isPortFreeServer(port, add)) {
                return false;
            }
            add = InetAddress.getLocalHost();
            if (!NetUtils.isPortFreeServer(port, add)) {
                return false;
            }
            add = InetAddress.getByName("localhost");
            return NetUtils.isPortFreeServer(port, add);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isPortFreeServer(int port, InetAddress add) {
        try {
            ServerSocket ss = new ServerSocket(port, 100, add);
            ss.close();
            NetUtils.printd(add.toString() + " : " + port + " --> FREE");
            return true;
        }
        catch (Exception e) {
            NetUtils.printd(add.toString() + " : " + port + " --> IN USE");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFreePort() {
        int freePort = 0;
        boolean portFound = false;
        ServerSocket serverSocket = null;
        Class<NetUtils> clazz = NetUtils.class;
        synchronized (NetUtils.class) {
            try {
                serverSocket = new ServerSocket(0);
                freePort = serverSocket.getLocalPort();
                portFound = true;
            }
            catch (Exception e) {
            }
            finally {
                if (!portFound) {
                    freePort = 0;
                }
                try {
                    if (serverSocket != null) {
                        serverSocket.close();
                        if (!serverSocket.isClosed()) {
                            throw new Exception("Socket is not closed. The port is: " + freePort);
                        }
                    }
                }
                catch (Exception e) {
                    freePort = 0;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return freePort;
        }
    }

    public static boolean isSecurePort(String hostname, int port) throws IOException, ConnectException, SocketTimeoutException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(hostname, port), 4000);
        OutputStream ostream = socket.getOutputStream();
        ostream.write(TEST_QUERY);
        InputStream istream = socket.getInputStream();
        for (int count = 0; count < 20; ++count) {
            try {
                if (istream.available() > 0) break;
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        byte[] input = new byte[istream.available()];
        int len = istream.read(input);
        socket.close();
        String response = new String(input).toLowerCase();
        boolean isSecure = true;
        if (response.length() == 0) {
            isSecure = false;
        } else if (response.startsWith("http/1.")) {
            isSecure = false;
        } else if (response.indexOf("<html") != -1) {
            isSecure = false;
        } else if (response.indexOf("connection: ") != -1) {
            isSecure = false;
        }
        return isSecure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRunning(String host, int port) {
        Socket server = null;
        try {
            server = new Socket(host, port);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (server != null) {
                try {
                    server.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static final boolean isRunning(int port) {
        return NetUtils.isRunning(null, port);
    }

    private static boolean isThisMe(String hostname) {
        try {
            InetAddress[] myadds = NetUtils.getHostAddresses();
            InetAddress[] theiradds = InetAddress.getAllByName(hostname);
            for (int i = 0; i < theiradds.length; ++i) {
                if (theiradds[i].isLoopbackAddress()) {
                    return true;
                }
                for (int j = 0; j < myadds.length; ++j) {
                    if (!myadds[j].equals(theiradds[i])) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println("80: " + NetUtils.isPortFree(80));
        System.out.println("777: " + NetUtils.isPortFree(777));
        System.out.println("8000: " + NetUtils.isPortFree(8000));
    }
}

