/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.encryp;

import com.bes.mq.encryp.BESMQMessageEncryptor;
import com.bes.mq.encryp.jasypt.BESMQJasyptPBEMessageEncryptor;

public class EncryptionPolicy {
    private boolean useEncryption;
    private String algorithm;
    private boolean usePool = false;
    private int poolSize = 10;
    private String password = null;

    public boolean isUseEncryption() {
        return this.useEncryption;
    }

    public void setUseEncryption(boolean useEncryption) {
        this.useEncryption = useEncryption;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public boolean isUsePool() {
        return this.usePool;
    }

    public void setUsePool(boolean usePool) {
        this.usePool = usePool;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public EncryptionPolicy copy() {
        EncryptionPolicy copy = new EncryptionPolicy();
        copy.useEncryption = this.useEncryption;
        copy.algorithm = this.algorithm;
        copy.usePool = this.usePool;
        copy.poolSize = this.poolSize;
        copy.password = this.password;
        return copy;
    }

    public String findEncryptionPassword() {
        String password = System.getenv("BESMQ_ENCRYPTION_PASSWORD");
        if (password == null || password.isEmpty()) {
            password = this.password;
        }
        return password;
    }

    public BESMQMessageEncryptor createBESMQMessageEncryptor() {
        return new BESMQJasyptPBEMessageEncryptor(this);
    }
}

