/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.encryp.jasypt;

import com.bes.mq.encryp.BESMQMessageEncryptor;
import com.bes.mq.encryp.EncryptionPolicy;
import com.bes.mq.org.jasypt.encryption.ByteEncryptor;
import com.bes.mq.org.jasypt.encryption.pbe.PooledPBEByteEncryptor;
import com.bes.mq.org.jasypt.encryption.pbe.StandardPBEByteEncryptor;
import com.bes.mq.util.ByteSequence;
import com.bes.mq.util.ServiceStopper;
import com.bes.mq.util.ServiceSupport;

public class BESMQJasyptPBEMessageEncryptor
extends ServiceSupport
implements BESMQMessageEncryptor {
    private final EncryptionPolicy encryptionPolicy;
    private ByteEncryptor byteEncryptor = null;

    public BESMQJasyptPBEMessageEncryptor(EncryptionPolicy encryptionPolicy) {
        this.encryptionPolicy = encryptionPolicy;
    }

    public byte[] encrypt(byte[] message) {
        return this.byteEncryptor.encrypt(message);
    }

    public byte[] decrypt(byte[] encryptedMessage) {
        return this.byteEncryptor.decrypt(encryptedMessage);
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        this.byteEncryptor = null;
    }

    protected void doStart() throws Exception {
        if (this.byteEncryptor != null) {
            return;
        }
        if (this.encryptionPolicy.isUsePool()) {
            PooledPBEByteEncryptor pe = new PooledPBEByteEncryptor();
            pe.setPoolSize(this.encryptionPolicy.getPoolSize());
            if (this.encryptionPolicy.getAlgorithm() != null && !this.encryptionPolicy.getAlgorithm().isEmpty()) {
                pe.setAlgorithm(this.encryptionPolicy.getAlgorithm());
            }
            pe.setPassword(this.encryptionPolicy.findEncryptionPassword());
            pe.initialize();
            this.byteEncryptor = pe;
        } else {
            StandardPBEByteEncryptor se = new StandardPBEByteEncryptor();
            if (this.encryptionPolicy.getAlgorithm() != null && !this.encryptionPolicy.getAlgorithm().isEmpty()) {
                se.setAlgorithm(this.encryptionPolicy.getAlgorithm());
            }
            se.setPassword(this.encryptionPolicy.findEncryptionPassword());
            se.initialize();
            this.byteEncryptor = se;
        }
    }

    public ByteSequence encrypt(ByteSequence message) {
        ByteSequence copy = message.compactCopy();
        byte[] encryptedData = this.byteEncryptor.encrypt(copy.data);
        copy.data = encryptedData;
        copy.offset = 0;
        copy.length = encryptedData.length;
        return copy;
    }

    public ByteSequence decrypt(ByteSequence encryptedMessage) {
        ByteSequence copy = encryptedMessage.compactCopy();
        byte[] decryptedData = this.byteEncryptor.decrypt(copy.data);
        copy.data = decryptedData;
        copy.offset = 0;
        copy.length = decryptedData.length;
        return copy;
    }
}

