/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.file;

import com.bes.mq.BESMQConnection;
import com.bes.mq.BESMQMessageConsumer;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQFileMessage;
import com.bes.mq.command.FileChunk;
import com.bes.mq.command.FileRequest;
import com.bes.mq.command.FileRequestAck;
import com.bes.mq.command.MessageId;
import com.bes.mq.command.Response;
import com.bes.mq.file.FileTransferListener;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.TransportListenerAdapter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.JMSException;

public class FileRequestor
extends TransportListenerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(FileRequestor.class);
    private final BESMQMessageConsumer consumer;
    private final BESMQConnection connection;
    private boolean retransferMode;
    private File metaFile = null;
    private RandomAccessFile metaRaf = null;
    private FileChannel metaChannel;
    private FileLock metaFileLock;
    private String uid = null;
    private byte[] uidBytes = null;
    private volatile long currentPos;
    private long size;
    private File file = null;
    private RandomAccessFile fileRaf = null;
    private volatile boolean stopped = false;
    private volatile boolean complete = false;
    private volatile String destPath = null;
    private MessageId messageId;
    private String filePath;
    private long startRequestTime = 0L;
    private long lastFlushTime = 0L;
    private AtomicReference<Exception> lastException = new AtomicReference();
    private AtomicReference<FileRequest> fileRequestRef = new AtomicReference();
    private AtomicReference<FileRequestAck> fileRequestAckRef = new AtomicReference();
    private Map<BESMQMessageConsumer, BESMQFileMessage> relatedConsumersAndMsgs = new ConcurrentHashMap<BESMQMessageConsumer, BESMQFileMessage>();
    private long lastCur = 0L;
    private long lastTime = System.currentTimeMillis();

    public FileRequestor(BESMQConnection connection, BESMQMessageConsumer consumer, String uid) {
        File recvDir;
        this.connection = connection;
        this.consumer = consumer;
        this.uid = uid;
        try {
            this.uidBytes = uid.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            this.uidBytes = uid.getBytes();
        }
        this.retransferMode = connection.getFileTransferPolicy().isResumeMode();
        File metaDir = new File(connection.getFileTransferPolicy().getMetaDir());
        if (!metaDir.exists()) {
            metaDir.mkdirs();
        }
        if (!(recvDir = new File(connection.getFileTransferPolicy().getRecvFilesDir())).exists()) {
            recvDir.mkdirs();
        }
        this.connection.addTransportListener(this);
    }

    public void attatched(BESMQMessageConsumer consumer, BESMQFileMessage fileMessage) {
        this.relatedConsumersAndMsgs.put(consumer, fileMessage);
    }

    public Response processFileMessage(BESMQFileMessage fileMessage) throws JMSException {
        this.messageId = fileMessage.getMessageId();
        this.filePath = fileMessage.getFilePath();
        if (this.complete) {
            LOG.info("Request file " + this.filePath + " has finished(transportResumed)");
            return null;
        }
        this.startRequestTime = System.currentTimeMillis();
        FileRequest fileRequest = this.readFileMeta(fileMessage);
        if (this.complete) {
            LOG.info("Request file " + this.filePath + " has finished");
            return null;
        }
        this.connection.asyncSendPacket(fileRequest);
        this.fileRequestRef.set(fileRequest);
        this.updateProgress(this.size, this.currentPos, true);
        LOG.info("Start to request file " + this.filePath + ", " + " pos " + this.currentPos);
        return null;
    }

    public Response processFileRequestAck(FileRequestAck fileRequestAck) throws JMSException {
        this.fileRequestAckRef.set(fileRequestAck);
        try {
            if (fileRequestAck.getResultCode() == 0) {
                this.size = fileRequestAck.getSize();
                LOG.info("Receive request ack for file " + this.filePath + ", size " + this.size);
                this.updateProgress(this.size, this.currentPos, true);
                if (this.size == this.currentPos) {
                    LOG.info("Request file " + this.filePath + " has completed");
                    this.onComplete();
                } else if (this.fileRaf == null) {
                    this.fileRaf = new RandomAccessFile(this.file, "rw");
                }
            } else {
                this.onComplete();
            }
        }
        catch (IOException e) {
            LOG.error("Failed to process request ack for file " + this.filePath, e);
        }
        return null;
    }

    public Response processFileChunk(FileChunk fileChunk) throws JMSException {
        block9: {
            if (this.stopped) {
                LOG.warn("FileMessageRequestor has stopped, but received FileChunk, uid " + fileChunk.getUid());
                return null;
            }
            if (this.fileRequestAckRef.get() == null) {
                LOG.warn("FileRequestAck hasn't received, but received FileChunk, uid " + fileChunk.getUid());
                return null;
            }
            if (this.fileRequestAckRef.get().getResultCode() == 1) {
                LOG.warn("FileRequestAck marked with FILE_NOT_FOUND, but received FileChunk, uid " + fileChunk.getUid());
                return null;
            }
            try {
                if (fileChunk.getPosition() != this.currentPos) {
                    throw new JMSException("Invliad file chunk for FileMessage,uid " + this.uid);
                }
                this.fileRaf.seek(this.currentPos);
                this.fileRaf.write(fileChunk.getContent());
                this.currentPos += (long)fileChunk.getContent().length;
                this.updateProgress(this.size, this.currentPos, false);
                this.writeFileMeta(false);
                if (this.currentPos != this.size) break block9;
                LOG.info("Finished to request file " + this.filePath + ", cost " + (System.currentTimeMillis() - this.startRequestTime) + "ms");
                try {
                    if (this.fileRaf != null) {
                        this.fileRaf.close();
                        this.fileRaf = null;
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.onComplete();
            }
            catch (Exception e) {
                LOG.error("Failed to process file chunk for file " + this.filePath, e);
                this.lastException.set(e);
                this.stop();
            }
        }
        return null;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        this.writeFileMeta(true);
        try {
            if (this.metaFileLock != null) {
                this.metaFileLock.release();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.metaChannel != null) {
                this.metaChannel.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.metaRaf != null) {
                this.metaRaf.close();
                this.metaRaf = null;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.fileRaf != null) {
                this.fileRaf.close();
                this.fileRaf = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.updateProgress(this.size, this.currentPos, true);
        this.connection.removeTransportListener(this);
        FileRequestor fileRequestor = this;
        synchronized (fileRequestor) {
            this.notifyAll();
        }
    }

    private void onComplete() throws JMSException {
        this.complete = true;
        this.stop();
    }

    private FileRequest readFileMeta(BESMQFileMessage msg) throws JMSException {
        JMSException jmsEx;
        File recvFilesDir;
        File metaDir = new File(this.connection.getFileTransferPolicy().getMetaDir());
        if (!metaDir.exists()) {
            metaDir.mkdirs();
        }
        if (!(recvFilesDir = new File(this.connection.getFileTransferPolicy().getRecvFilesDir())).exists()) {
            recvFilesDir.mkdirs();
        }
        this.currentPos = 0L;
        this.file = new File(recvFilesDir, this.uid);
        this.metaFile = new File(metaDir, this.getMetaFileName());
        if (this.retransferMode) {
            block20: {
                if (this.metaFile.exists()) {
                    try {
                        this.metaRaf = new RandomAccessFile(this.metaFile, "rw");
                        if (this.metaFile.length() <= 0L) break block20;
                        this.metaRaf.readByte();
                        int uidLen = this.metaRaf.readInt();
                        if (uidLen > 0) {
                            byte[] uidBytes = new byte[uidLen];
                            this.metaRaf.read(uidBytes);
                            String savedUid = new String(uidBytes, "UTF8");
                            if (savedUid.equals(this.uid)) {
                                this.size = this.metaRaf.readLong();
                                this.currentPos = this.metaRaf.readLong();
                                this.complete = this.size == this.currentPos;
                                LOG.info("Found resume meta for FileMessage, uid: " + this.uid + ", size: " + this.size + " pos: " + this.currentPos + " file: " + msg.getFilePath());
                            } else {
                                LOG.warn("Invalid file uid, expected " + this.uid + ", saved " + savedUid + ", will request file from start position. file: " + msg.getFilePath());
                            }
                            break block20;
                        }
                        LOG.warn("Invalid file uid len" + uidLen + ", will request file from start position. file: " + msg.getFilePath());
                    }
                    catch (IOException e) {
                        LOG.warn("Read file meta failed, will request file from start position. file: " + msg.getFilePath(), e);
                    }
                } else {
                    try {
                        this.metaFile.createNewFile();
                        this.metaRaf = new RandomAccessFile(this.metaFile, "rw");
                    }
                    catch (IOException e) {
                        JMSException jmsEx2 = new JMSException("Create meta file failed: " + this.metaFile.getAbsolutePath());
                        jmsEx2.initCause(e);
                        throw jmsEx2;
                    }
                }
            }
            try {
                this.metaChannel = this.metaRaf.getChannel();
                this.metaFileLock = this.metaChannel.tryLock();
                if (this.metaFileLock == null) {
                    throw new JMSException("Can't hold the meta file lock, may be transfer is in progress: " + this.metaFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                jmsEx = new JMSException("Can't hold the meta file lock, may be transfer is in progress: " + this.metaFile.getAbsolutePath());
                jmsEx.initCause(e);
                throw jmsEx;
            }
        }
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                jmsEx = new JMSException("Can't create file " + this.file.getAbsolutePath());
                jmsEx.initCause(e);
                throw jmsEx;
            }
        } else if (this.file.length() < this.currentPos) {
            LOG.warn("Invalid file len, saved " + this.currentPos + " got " + this.file.length() + ", will request file from start position");
            this.currentPos = 0L;
        }
        FileRequest meta = new FileRequest();
        meta.setResponseRequired(true);
        meta.setUid(this.uid);
        meta.setPosition(this.currentPos);
        meta.setChunkSize(this.connection.getFileTransferPolicy().getChunkSize());
        meta.setDispatchAsync(this.consumer.getConsumerInfo().isDispatchAsync());
        meta.setResumeMode(this.retransferMode);
        meta.setDeliveryMode(msg.getJMSDeliveryMode());
        meta.setDestination((BESMQDestination)msg.getJMSDestination());
        return meta;
    }

    private void writeFileMeta(boolean force) {
        if (!this.retransferMode) {
            return;
        }
        long currTime = System.currentTimeMillis();
        if (force || this.lastFlushTime == 0L || currTime - this.lastFlushTime > this.connection.getFileTransferPolicy().getMetaFlushPeriodInMills()) {
            this.lastFlushTime = currTime;
            try {
                this.metaRaf.seek(0L);
                this.metaRaf.writeByte(1);
                this.metaRaf.writeInt(this.uidBytes.length);
                this.metaRaf.write(this.uidBytes);
                this.metaRaf.writeLong(this.size);
                this.metaRaf.writeLong(this.currentPos);
            }
            catch (IOException e) {
                LOG.error("Failed to write meta file " + this.uid, e);
            }
        }
    }

    private String getMetaFileName() throws JMSException {
        String fileName = this.uid + ".meta";
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForComplete(BESMQMessageConsumer consumer, BESMQFileMessage fileMessage, long timeout, Runnable timeoutHook) throws JMSException {
        if (!this.relatedConsumersAndMsgs.containsKey(consumer)) {
            LOG.error("FileMessageRequestor not contains the consumer: " + consumer);
            return;
        }
        if (!this.complete && !this.stopped) {
            FileRequestor fileRequestor = this;
            synchronized (fileRequestor) {
                if (!this.complete && !this.stopped) {
                    try {
                        if (timeout < 0L) {
                            this.wait();
                        } else if (timeout != 0L) {
                            this.wait(timeout);
                        }
                    }
                    catch (InterruptedException e) {
                        throw new JMSException("FileMessageRequestor waitForCompele Interrupted");
                    }
                }
            }
        }
        if (this.complete) {
            boolean readOnlyBody = fileMessage.isReadOnlyBody();
            boolean readOnlyProperties = fileMessage.isReadOnlyProperties();
            try {
                fileMessage.setReadOnlyBody(false);
                fileMessage.setReadOnlyProperties(false);
                if (this.fileRequestAckRef.get() != null && this.fileRequestAckRef.get().getResultCode() == 1) {
                    fileMessage.setBooleanProperty("BESMQ_FT_FILE_NOT_FOUND", true);
                } else {
                    if (this.destPath == null) {
                        boolean rename;
                        File destFile;
                        String filePath = fileMessage.getFileName();
                        String renameTo = fileMessage.getStringProperty("BESMQ_FT_RENAME_TO");
                        if (renameTo != null && renameTo.length() > 0) {
                            filePath = renameTo;
                        }
                        if (filePath.indexOf(":") > -1) {
                            filePath = filePath.replaceAll(":", "_");
                        }
                        if ((destFile = new File(this.connection.getFileTransferPolicy().getRecvFilesDir(), filePath)).getParentFile() != null) {
                            destFile.getParentFile().mkdirs();
                        }
                        if (destFile.exists() && !this.connection.getFileTransferPolicy().isOverwrite()) {
                            destFile = new File(destFile.getPath() + "." + this.uid);
                        }
                        if (!(rename = this.file.renameTo(destFile)) && destFile.exists() && this.connection.getFileTransferPolicy().isOverwrite()) {
                            LOG.warn("Failed to rename file " + this.file.getAbsolutePath() + " to " + destFile.getAbsolutePath() + ", will try to delete dest file firstly");
                            if (!destFile.delete()) {
                                LOG.warn("Failed to delete dest file " + destFile.getAbsolutePath());
                            } else {
                                rename = this.file.renameTo(destFile);
                            }
                        }
                        if (rename) {
                            this.destPath = destFile.getAbsolutePath();
                        } else {
                            LOG.warn("Failed to rename file " + this.file.getAbsolutePath() + " to " + destFile.getAbsolutePath());
                            this.destPath = this.file.getAbsolutePath();
                        }
                    }
                    fileMessage.setFilePath(this.destPath);
                }
                Object var13_14 = null;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                fileMessage.setReadOnlyBody(readOnlyBody);
                fileMessage.setReadOnlyProperties(readOnlyProperties);
                throw throwable;
            }
            fileMessage.setReadOnlyBody(readOnlyBody);
            fileMessage.setReadOnlyProperties(readOnlyProperties);
            if (this.currentPos == this.size) {
                if (this.metaFile != null) {
                    this.metaFile.delete();
                }
            } else if (this.metaFile.length() == 0L) {
                this.metaFile.delete();
            }
            this.relatedConsumersAndMsgs.remove(consumer);
            if (this.relatedConsumersAndMsgs.isEmpty()) {
                this.connection.removeFileMessageRequestor(this.uid);
            }
        } else if (!this.stopped && timeout >= 0L) {
            if (timeoutHook != null) {
                timeoutHook.run();
            }
        } else {
            JMSException je = new JMSException("Failed to request file " + this.filePath);
            if (this.lastException.get() != null) {
                je.initCause(this.lastException.get());
            }
            throw je;
        }
    }

    private void updateProgress(long size, long current, boolean force) {
        if (!force) {
            if ((current - this.lastCur) * 100L / Math.max(size, 1L) < 1L) {
                return;
            }
            this.lastCur = current;
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastTime < 1000L) {
                return;
            }
            this.lastTime = currentTime;
        }
        double percent = current * 100L / Math.max(size, 1L);
        for (BESMQMessageConsumer cnext : this.relatedConsumersAndMsgs.keySet()) {
            FileTransferListener fileTransferListener = cnext.getFileTransferListener();
            if (fileTransferListener == null) continue;
            fileTransferListener.onTransfer(this.messageId, this.filePath, size, current, percent);
        }
    }

    public void transportInterupted() {
        LOG.info("The connection transport interupted");
    }

    public void transportResumed() {
        if (this.complete) {
            LOG.warn("The connection transport resumed, request file " + this.filePath + " has completed");
        }
        FileRequest fileRequest = null;
        fileRequest = this.fileRequestRef.get();
        if (fileRequest != null) {
            fileRequest.setPosition(this.currentPos);
            try {
                LOG.info("The connection transport resumed, resend the FileRequest for file " + this.filePath + ", pos " + fileRequest.getPosition());
                this.connection.asyncSendPacket(fileRequest);
            }
            catch (JMSException e) {
                LOG.error("Failed to resend FileRequest to broker", e);
            }
        } else {
            LOG.warn("The connection transport resumed, but can't get the previous FileRequest for file " + this.filePath);
        }
    }
}

