/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.file;

import com.bes.mq.BESMQConnection;
import com.bes.mq.BESMQMessageProducer;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQFileMessage;
import com.bes.mq.command.FileChunk;
import com.bes.mq.command.FileSend;
import com.bes.mq.command.FileSendAck;
import com.bes.mq.file.FileTransferError;
import com.bes.mq.file.FileTransferException;
import com.bes.mq.file.FileTransferListener;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.TransportListenerAdapter;
import com.bes.mq.util.MD5Util;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.UUID;
import javax.jms.JMSException;
import javax.jms.Message;

public class FileSender
extends TransportListenerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(FileSender.class);
    private final BESMQFileMessage fileMessage;
    private final BESMQMessageProducer producer;
    private final BESMQConnection connection;
    private final FileTransferListener transferListener;
    private boolean retransferMode = true;
    private boolean removeSrc = false;
    private File metaDir = null;
    private File metaFile = null;
    private RandomAccessFile metaRaf = null;
    private FileChannel metaChannel;
    private FileLock metaFileLock;
    private String filePath = null;
    private File sendFile = null;
    private long fileSize = 0L;
    private String uid = null;
    private byte[] uidBytes = null;
    private long currentPos;
    private volatile boolean transportResumed = false;
    private long lastFlushTime = 0L;
    private long lastCur;
    private long lastTime = System.currentTimeMillis();

    public FileSender(BESMQFileMessage fileMessage) {
        this.fileMessage = fileMessage;
        this.producer = fileMessage.getMessageProducer();
        this.connection = fileMessage.getConnection();
        this.transferListener = this.producer.getFileTransferListener();
        this.connection.addTransportListener(this);
    }

    /*
     * Loose catch block
     */
    public void sendFile() throws JMSException {
        block54: {
            block50: {
                this.metaDir = new File(this.connection.getFileTransferPolicy().getMetaDir());
                if (!this.metaDir.exists()) {
                    this.metaDir.mkdirs();
                }
                this.retransferMode = this.fileMessage.getBooleanProperty("BESMQ_FT_RETRANSFER_MODE");
                this.removeSrc = this.fileMessage.getBooleanProperty("BESMQ_FT_REMOVE_SRC");
                this.filePath = this.fileMessage.getFilePath();
                this.sendFile = new File(this.filePath);
                if (!this.sendFile.exists()) {
                    this.sendFile = new File(this.connection.getFileTransferPolicy().getSendFilesDir(), this.filePath);
                    if (!this.sendFile.exists()) {
                        String workingDir = new File(".").getAbsolutePath();
                        throw new JMSException("Not found file " + this.filePath + " in workingDir: " + workingDir + " or SendFilesDir: " + this.connection.getFileTransferPolicy().getSendFilesDir());
                    }
                }
                this.fileSize = this.sendFile.length();
                LOG.info("Send target file located " + this.sendFile.getAbsolutePath());
                FileSend fileMeta = this.readFileMeta(this.fileMessage);
                if (this.currentPos < this.fileSize) {
                    LOG.info("Start to send file " + this.sendFile.getAbsolutePath() + ", size " + this.fileSize + " pos " + this.currentPos);
                    long startTime = System.currentTimeMillis();
                    RandomAccessFile raf = null;
                    raf = new RandomAccessFile(this.sendFile, "r");
                    boolean resendMeta = true;
                    int resumeCount = 0;
                    int chunkSize = this.connection.getFileTransferPolicy().getChunkSize();
                    while (this.connection.isStarted() && this.currentPos < this.fileSize) {
                        try {
                            int minLength;
                            byte[] content;
                            int read;
                            if (resendMeta) {
                                resendMeta = false;
                                fileMeta.setPosition(this.currentPos);
                                FileSendAck fileMetaAck = (FileSendAck)this.connection.syncSendPacket(fileMeta);
                                this.currentPos = fileMetaAck.getResume() ? fileMetaAck.getResumePos() : 0L;
                                this.lastCur = this.currentPos;
                                raf.seek(this.currentPos);
                                this.updateProgress(this.currentPos, true);
                                this.writeFileMeta(false);
                            }
                            if ((read = raf.read(content = new byte[minLength = this.fileSize - this.currentPos > (long)chunkSize ? chunkSize : (int)(this.fileSize - this.currentPos)])) == -1) break;
                            FileChunk fileChunk = new FileChunk();
                            fileChunk.setUid(this.uid);
                            fileChunk.setPosition(this.currentPos);
                            fileChunk.setContent(content);
                            this.connection.syncSendPacket(fileChunk);
                            this.currentPos += (long)read;
                            this.updateProgress(this.currentPos, false);
                            this.writeFileMeta(false);
                        }
                        catch (JMSException e) {
                            if (this.transportResumed) {
                                FileTransferException fte = null;
                                fte = FileTransferException.extract(e.getCause());
                                if (fte == null || fte.getErrCode() != FileTransferError.FILE_CHUNK_AHEAD_ERR.getErrCode() && fte.getErrCode() != FileTransferError.FILE_POSITION_INVALID_ERR.getErrCode()) continue;
                                resendMeta = true;
                                this.transportResumed = false;
                                LOG.info("Send file " + this.filePath + " is break caused by: " + fte.getMessage() + ", transfer will resume " + ++resumeCount + "st");
                                continue;
                            }
                            LOG.warn("Send file " + this.filePath + " error. pos " + this.currentPos, e);
                            throw e;
                        }
                    }
                    this.fileMessage.setFileName(this.sendFile.getName());
                    this.fileMessage.setStringProperty("BESMQ_FT_FILE_UID", this.uid);
                    this.fileMessage.setStringProperty("BESMQ_FT_FILE_ORIGIN_PATH", this.filePath);
                    LOG.info("Finished send file " + this.sendFile.getAbsolutePath() + ", cost " + (System.currentTimeMillis() - startTime) + "ms");
                    Object var13_17 = null;
                    try {
                        if (raf != null) {
                            raf.close();
                        }
                        break block50;
                    }
                    catch (IOException e1) {}
                    break block50;
                    {
                        catch (IOException e) {
                            JMSException jmse = new JMSException("Failed to send file to broker");
                            jmse.initCause(e);
                            throw jmse;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_18 = null;
                        try {
                            if (raf != null) {
                                raf.close();
                            }
                        }
                        catch (IOException e1) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            Object var16_22 = null;
            this.writeFileMeta(true);
            try {
                if (this.metaFileLock != null) {
                    this.metaFileLock.release();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.metaChannel != null) {
                    this.metaChannel.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.metaRaf != null) {
                    this.metaRaf.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.currentPos == this.fileSize) {
                    if (this.metaFile != null) {
                        this.metaFile.delete();
                    }
                    if (this.removeSrc && !this.fileMessage.isInTransaction() && !this.sendFile.delete()) {
                        LOG.warn("Failed to delete sended file ", (Object)this.sendFile.getAbsolutePath());
                    }
                } else if (this.metaFile.length() == 0L) {
                    this.metaFile.delete();
                }
                break block54;
            }
            catch (Exception e) {
                // empty catch block
            }
            {
                break block54;
                catch (JMSException e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var16_23 = null;
                this.writeFileMeta(true);
                try {
                    if (this.metaFileLock != null) {
                        this.metaFileLock.release();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    if (this.metaChannel != null) {
                        this.metaChannel.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.metaRaf != null) {
                        this.metaRaf.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    if (this.currentPos == this.fileSize) {
                        if (this.metaFile != null) {
                            this.metaFile.delete();
                        }
                        if (this.removeSrc && !this.fileMessage.isInTransaction() && !this.sendFile.delete()) {
                            LOG.warn("Failed to delete sended file ", (Object)this.sendFile.getAbsolutePath());
                        }
                    } else if (this.metaFile.length() == 0L) {
                        this.metaFile.delete();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.updateProgress(this.currentPos, true);
                this.connection.removeTransportListener(this);
                throw throwable;
            }
        }
        this.updateProgress(this.currentPos, true);
        this.connection.removeTransportListener(this);
    }

    private void writeFileMeta(boolean force) {
        if (!this.retransferMode) {
            return;
        }
        long currTime = System.currentTimeMillis();
        if (force || this.lastFlushTime == 0L || currTime - this.lastFlushTime > this.connection.getFileTransferPolicy().getMetaFlushPeriodInMills()) {
            this.lastFlushTime = currTime;
            try {
                this.metaRaf.seek(0L);
                this.metaRaf.writeByte(1);
                this.metaRaf.writeInt(this.uidBytes.length);
                this.metaRaf.write(this.uidBytes);
                this.metaRaf.writeLong(this.currentPos);
            }
            catch (IOException e) {
                LOG.error("Failed to write transfer meta for file " + this.filePath, e);
            }
        }
    }

    private FileSend readFileMeta(Message msg) throws JMSException {
        this.uid = null;
        this.currentPos = 0L;
        this.metaFile = new File(this.metaDir, this.getMetaFileName(msg));
        if (this.retransferMode) {
            block17: {
                if (this.metaFile.exists()) {
                    if (this.metaFile.length() > 0L) {
                        try {
                            this.metaRaf = new RandomAccessFile(this.metaFile, "rw");
                            this.metaRaf.readByte();
                            int uidLen = this.metaRaf.readInt();
                            if (uidLen > 0) {
                                byte[] uidBytes = new byte[uidLen];
                                int len = this.metaRaf.read(uidBytes);
                                if (uidLen == len) {
                                    this.uid = new String(uidBytes, "UTF8");
                                    this.currentPos = this.metaRaf.readLong();
                                    LOG.info("Found resume meta for FileMessage,  file: " + this.filePath + ", uid: " + this.uid + " pos: " + this.currentPos);
                                } else {
                                    LOG.warn("Corrupted file uid " + this.uid + ", will transfer file from start position");
                                }
                                break block17;
                            }
                            LOG.warn("Invalid file uid len" + uidLen + ", will transfer file from start position");
                        }
                        catch (IOException e) {
                            LOG.warn("Read file meta failed, will transfer file from start position", e);
                        }
                    }
                } else {
                    try {
                        this.metaFile.createNewFile();
                        this.metaRaf = new RandomAccessFile(this.metaFile, "rw");
                    }
                    catch (IOException e) {
                        JMSException jmsEx = new JMSException("Create meta file failed: " + this.metaFile.getAbsolutePath());
                        jmsEx.initCause(e);
                        throw jmsEx;
                    }
                }
            }
            try {
                this.metaChannel = this.metaRaf.getChannel();
                this.metaFileLock = this.metaChannel.tryLock();
                if (this.metaFileLock == null) {
                    throw new JMSException("Can't hold the meta file lock, may be transfer is in progress: " + this.metaFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException("Can't hold the meta file lock, may be transfer is in progress: " + this.metaFile.getAbsolutePath());
                jmsEx.initCause(e);
                throw jmsEx;
            }
        }
        if (this.uid == null) {
            this.uid = UUID.randomUUID().toString().replaceAll("-", "");
        }
        try {
            this.uidBytes = this.uid.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            this.uidBytes = this.uid.getBytes();
        }
        FileSend meta = new FileSend();
        meta.setResponseRequired(true);
        meta.setSize(this.fileSize);
        meta.setUid(this.uid);
        meta.setChecksum(0L);
        meta.setPosition(this.currentPos);
        meta.setResumeMode(this.retransferMode);
        meta.setDeliveryMode(msg.getJMSDeliveryMode());
        meta.setDestination((BESMQDestination)msg.getJMSDestination());
        return meta;
    }

    private String getMetaFileName(Message msg) throws JMSException {
        String name = this.sendFile.getName();
        String path = this.sendFile.getAbsolutePath();
        StringBuilder sb = new StringBuilder();
        sb.append(path).append(this.sendFile.length()).append(this.sendFile.lastModified()).append(this.connection.getBrokerAddress()).append(((BESMQDestination)msg.getJMSDestination()).getName());
        String fileName = name + "." + MD5Util.md5Str(sb.toString()) + ".meta";
        return fileName;
    }

    private void updateProgress(long current, boolean force) {
        if (this.transferListener == null) {
            return;
        }
        if (!force) {
            if ((current - this.lastCur) * 100L / Math.max(this.fileSize, 1L) < 1L) {
                return;
            }
            this.lastCur = current;
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastTime < 1000L) {
                return;
            }
            this.lastTime = currentTime;
        }
        double percent = current * 100L / Math.max(this.fileSize, 1L);
        this.transferListener.onTransfer(this.fileMessage.getMessageId(), this.filePath, this.fileSize, current, percent);
    }

    public void transportInterupted() {
        LOG.info("The connection transport interupted");
    }

    public void transportResumed() {
        LOG.info("The connection transport resumed");
        this.transportResumed = true;
    }
}

