/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.file;

import com.bes.mq.file.FileTransferError;
import java.io.IOException;

public class FileTransferException
extends IOException {
    private static final long serialVersionUID = 1L;
    private int errCode;

    public FileTransferException(int errCode, String errMessage) {
        super(errMessage);
        this.errCode = errCode;
    }

    public FileTransferException(int errCode, String message, Throwable cause) {
        super(message, cause);
        this.errCode = errCode;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public static FileTransferException extract(Throwable t) {
        if (t == null || t.getMessage() == null) {
            return null;
        }
        if (t.getMessage().indexOf(FileTransferError.FILE_CHUNK_AHEAD_ERR.getErrMsg()) != -1) {
            return new FileTransferException(FileTransferError.FILE_CHUNK_AHEAD_ERR.getErrCode(), t.getMessage());
        }
        if (t.getMessage().indexOf(FileTransferError.FILE_UID_INVALID_ERR.getErrMsg()) != -1) {
            return new FileTransferException(FileTransferError.FILE_UID_INVALID_ERR.getErrCode(), t.getMessage());
        }
        if (t.getMessage().indexOf(FileTransferError.FILE_POSITION_INVALID_ERR.getErrMsg()) != -1) {
            return new FileTransferException(FileTransferError.FILE_POSITION_INVALID_ERR.getErrCode(), t.getMessage());
        }
        return null;
    }
}

