/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.filter;

import com.bes.mq.command.BESMQDestination;
import com.bes.mq.filter.DestinationFilter;

public class CompositeDestinationFilter
extends DestinationFilter {
    private DestinationFilter[] filters;

    public CompositeDestinationFilter(BESMQDestination destination) {
        BESMQDestination[] destinations = destination.getCompositeDestinations();
        this.filters = new DestinationFilter[destinations.length];
        for (int i = 0; i < destinations.length; ++i) {
            BESMQDestination childDestination = destinations[i];
            this.filters[i] = DestinationFilter.parseFilter(childDestination);
        }
    }

    public boolean matches(BESMQDestination destination) {
        for (int i = 0; i < this.filters.length; ++i) {
            if (!this.filters[i].matches(destination)) continue;
            return true;
        }
        return false;
    }

    public boolean isWildcard() {
        return true;
    }
}

