/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.filter;

import com.bes.mq.command.BESMQDestination;
import com.bes.mq.filter.BooleanExpression;
import com.bes.mq.filter.CompositeDestinationFilter;
import com.bes.mq.filter.DestinationPath;
import com.bes.mq.filter.MessageEvaluationContext;
import com.bes.mq.filter.PrefixDestinationFilter;
import com.bes.mq.filter.SimpleDestinationFilter;
import com.bes.mq.filter.WildcardDestinationFilter;
import com.bes.mq.util.JMSExceptionSupport;
import java.io.IOException;
import javax.jms.JMSException;

public abstract class DestinationFilter
implements BooleanExpression {
    public static final String ANY_DESCENDENT = ">";
    public static final String ANY_CHILD = "*";

    public Object evaluate(MessageEvaluationContext message) throws JMSException {
        return this.matches(message) ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean matches(MessageEvaluationContext message) throws JMSException {
        try {
            if (message.isDropped()) {
                return false;
            }
            return this.matches(message.getMessage().getDestination());
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    public abstract boolean matches(BESMQDestination var1);

    public static DestinationFilter parseFilter(BESMQDestination destination) {
        if (destination.isComposite()) {
            return new CompositeDestinationFilter(destination);
        }
        String[] paths = DestinationPath.getDestinationPaths(destination);
        int idx = paths.length - 1;
        if (idx >= 0) {
            String lastPath = paths[idx];
            if (lastPath.equals(ANY_DESCENDENT)) {
                return new PrefixDestinationFilter(paths, destination.getDestinationType());
            }
            while (idx >= 0) {
                if (!(lastPath = paths[idx--]).equals(ANY_CHILD)) continue;
                return new WildcardDestinationFilter(paths, destination.getDestinationType());
            }
        }
        return new SimpleDestinationFilter(destination);
    }

    public abstract boolean isWildcard();
}

